/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.keycloak.models.utils.HmacOTP;

public class TimeBasedOTP
extends HmacOTP {
    public static final int DEFAULT_INTERVAL_SECONDS = 30;
    public static final int DEFAULT_DELAY_WINDOW = 1;
    private Clock clock;

    public TimeBasedOTP() {
        this("HmacSHA1", 6, 30, 1);
    }

    public TimeBasedOTP(String algorithm, int numberDigits, int timeIntervalInSeconds, int lookAheadWindow) {
        super(numberDigits, algorithm, lookAheadWindow);
        this.clock = new Clock(timeIntervalInSeconds);
    }

    public String generateTOTP(String secretKey) {
        long T = this.clock.getCurrentInterval();
        String steps = Long.toHexString(T).toUpperCase();
        while (steps.length() < 16) {
            steps = "0" + steps;
        }
        return this.generateOTP(secretKey, steps, this.numberDigits, this.algorithm);
    }

    public boolean validateTOTP(String token, byte[] secret) {
        long currentInterval = this.clock.getCurrentInterval();
        for (int i = this.lookAheadWindow; i >= 0; --i) {
            String steps = Long.toHexString(currentInterval - (long)i).toUpperCase();
            while (steps.length() < 16) {
                steps = "0" + steps;
            }
            String candidate = this.generateOTP(new String(secret), steps, this.numberDigits, this.algorithm);
            if (!candidate.equals(token)) continue;
            return true;
        }
        return false;
    }

    public void setCalendar(Calendar calendar) {
        this.clock.setCalendar(calendar);
    }

    private static class Clock {
        private final int interval;
        private Calendar calendar;

        public Clock(int interval) {
            this.interval = interval;
        }

        public long getCurrentInterval() {
            Calendar currentCalendar = this.calendar;
            if (currentCalendar == null) {
                currentCalendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
            }
            return currentCalendar.getTimeInMillis() / 1000L / (long)this.interval;
        }

        public void setCalendar(Calendar calendar) {
            this.calendar = calendar;
        }
    }
}

