/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.model;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.naming.ldap.Rdn;

public class LDAPDn {
    private final Deque<RDN> entries;

    private LDAPDn() {
        this.entries = new LinkedList<RDN>();
    }

    private LDAPDn(Deque<RDN> entries) {
        this.entries = entries;
    }

    public static LDAPDn fromString(String dnString) {
        String[] rdns;
        LDAPDn dn = new LDAPDn();
        if (dnString.trim().isEmpty()) {
            return dn;
        }
        for (String entryStr : rdns = dnString.split("(?<!\\\\),")) {
            if (entryStr.indexOf(43) == -1) {
                SubEntry subEntry = LDAPDn.parseSingleSubEntry(dn, entryStr);
                dn.addLast(new RDN(subEntry));
                continue;
            }
            String[] subEntries = entryStr.split("(?<!\\\\)\\+");
            RDN entry = new RDN();
            for (String subEntryStr : subEntries) {
                SubEntry subEntry = LDAPDn.parseSingleSubEntry(dn, subEntryStr);
                entry.addSubEntry(subEntry);
            }
            dn.addLast(entry);
        }
        return dn;
    }

    private static SubEntry parseSingleSubEntry(LDAPDn dn, String subEntryStr) {
        String[] rdn = subEntryStr.split("(?<!\\\\)=");
        if (rdn.length > 1) {
            return new SubEntry(rdn[0].trim(), rdn[1].trim());
        }
        return new SubEntry(rdn[0].trim(), "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LDAPDn)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return LDAPDn.toString(this.entries);
    }

    private static String toString(Collection<RDN> entries) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (RDN rdn : entries) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(rdn.toString());
        }
        return builder.toString();
    }

    public RDN getFirstRdn() {
        return this.entries.getFirst();
    }

    private static String unescapeValue(String escaped) {
        return Rdn.unescapeValue(escaped).toString();
    }

    private static String escapeValue(String unescaped) {
        return Rdn.escapeValue(unescaped);
    }

    public LDAPDn getParentDn() {
        LinkedList<RDN> parentDnEntries = new LinkedList<RDN>(this.entries);
        parentDnEntries.remove();
        return new LDAPDn(parentDnEntries);
    }

    public boolean isDescendantOf(LDAPDn expectedParentDn) {
        int parentEntriesCount = expectedParentDn.entries.size();
        LinkedList<RDN> myEntries = new LinkedList<RDN>(this.entries);
        boolean someRemoved = false;
        while (myEntries.size() > parentEntriesCount) {
            myEntries.removeFirst();
            someRemoved = true;
        }
        String myEntriesParentStr = LDAPDn.toString(myEntries).toLowerCase();
        String expectedParentDnStr = expectedParentDn.toString().toLowerCase();
        return someRemoved && myEntriesParentStr.equals(expectedParentDnStr);
    }

    public void addFirst(String rdnName, String rdnValue) {
        rdnValue = LDAPDn.escapeValue(rdnValue);
        this.entries.addFirst(new RDN(new SubEntry(rdnName, rdnValue)));
    }

    public void addFirst(RDN entry) {
        this.entries.addFirst(entry);
    }

    private void addLast(RDN entry) {
        this.entries.addLast(entry);
    }

    private static class SubEntry {
        private final String attrName;
        private String attrValue;

        private SubEntry(String attrName, String attrValue) {
            this.attrName = attrName;
            this.attrValue = attrValue;
        }

        private String getAttrName() {
            return this.attrName;
        }

        public String toString() {
            return this.toString(true);
        }

        private String toString(boolean escaped) {
            String val = escaped ? this.attrValue : LDAPDn.unescapeValue(this.attrValue);
            return this.attrName + '=' + val;
        }
    }

    public static class RDN {
        private List<SubEntry> subs = new LinkedList<SubEntry>();

        private RDN() {
        }

        private RDN(SubEntry subEntry) {
            this.subs.add(subEntry);
        }

        private void addSubEntry(SubEntry subEntry) {
            this.subs.add(subEntry);
        }

        public List<String> getAllKeys() {
            return this.subs.stream().map(rec$ -> ((SubEntry)rec$).getAttrName()).collect(Collectors.toList());
        }

        public String getAttrValue(String attrName) {
            for (SubEntry sub : this.subs) {
                if (!attrName.equalsIgnoreCase(sub.attrName)) continue;
                return LDAPDn.unescapeValue(sub.attrValue);
            }
            return null;
        }

        public void setAttrValue(String attrName, String newAttrValue) {
            for (SubEntry sub : this.subs) {
                if (!attrName.equalsIgnoreCase(sub.attrName)) continue;
                sub.attrValue = LDAPDn.escapeValue(newAttrValue);
                return;
            }
            this.addSubEntry(new SubEntry(attrName, LDAPDn.escapeValue(newAttrValue)));
        }

        public boolean removeAttrValue(String attrName) {
            SubEntry toRemove = null;
            for (SubEntry sub : this.subs) {
                if (!attrName.equalsIgnoreCase(sub.attrName)) continue;
                toRemove = sub;
            }
            if (toRemove != null) {
                this.subs.remove(toRemove);
                return true;
            }
            return false;
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean escaped) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (SubEntry subEntry : this.subs) {
                if (first) {
                    first = false;
                } else {
                    builder.append('+');
                }
                builder.append(subEntry.toString(escaped));
            }
            return builder.toString();
        }
    }
}

