/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.keycloak.authorization.jpa.entities.ResourceAttributeEntity;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.model.AbstractAuthorizationModel;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ResourceAdapter
extends AbstractAuthorizationModel
implements Resource,
JpaModel<ResourceEntity> {
    private ResourceEntity entity;
    private EntityManager em;
    private StoreFactory storeFactory;

    public ResourceAdapter(ResourceEntity entity, EntityManager em, StoreFactory storeFactory) {
        super(storeFactory);
        this.entity = entity;
        this.em = em;
        this.storeFactory = storeFactory;
    }

    @Override
    public ResourceEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public String getName() {
        return this.entity.getName();
    }

    public String getDisplayName() {
        return this.entity.getDisplayName();
    }

    public void setDisplayName(String name) {
        this.throwExceptionIfReadonly();
        this.entity.setDisplayName(name);
    }

    public Set<String> getUris() {
        return this.entity.getUris();
    }

    public void updateUris(Set<String> uri) {
        this.throwExceptionIfReadonly();
        this.entity.setUris(uri);
    }

    public void setName(String name) {
        this.throwExceptionIfReadonly();
        this.entity.setName(name);
    }

    public String getType() {
        return this.entity.getType();
    }

    public void setType(String type) {
        this.throwExceptionIfReadonly();
        this.entity.setType(type);
    }

    public List<Scope> getScopes() {
        LinkedList<Scope> scopes = new LinkedList<Scope>();
        for (ScopeEntity scope : this.entity.getScopes()) {
            scopes.add(this.storeFactory.getScopeStore().findById(scope.getId(), this.entity.getResourceServer()));
        }
        return Collections.unmodifiableList(scopes);
    }

    public String getIconUri() {
        return this.entity.getIconUri();
    }

    public void setIconUri(String iconUri) {
        this.throwExceptionIfReadonly();
        this.entity.setIconUri(iconUri);
    }

    public String getResourceServer() {
        return this.entity.getResourceServer();
    }

    public String getOwner() {
        return this.entity.getOwner();
    }

    public boolean isOwnerManagedAccess() {
        return this.entity.isOwnerManagedAccess();
    }

    public void setOwnerManagedAccess(boolean ownerManagedAccess) {
        this.throwExceptionIfReadonly();
        this.entity.setOwnerManagedAccess(ownerManagedAccess);
    }

    public void updateScopes(Set<Scope> toUpdate) {
        this.throwExceptionIfReadonly();
        HashSet<String> ids = new HashSet<String>();
        for (Scope scope : toUpdate) {
            ids.add(scope.getId());
        }
        Iterator<ScopeEntity> it = this.entity.getScopes().iterator();
        while (it.hasNext()) {
            ScopeEntity next = it.next();
            if (!ids.contains(next.getId())) {
                it.remove();
                continue;
            }
            ids.remove(next.getId());
        }
        for (String addId : ids) {
            this.entity.getScopes().add((ScopeEntity)this.em.getReference(ScopeEntity.class, (Object)addId));
        }
    }

    public Map<String, List<String>> getAttributes() {
        MultivaluedHashMap result = new MultivaluedHashMap();
        for (ResourceAttributeEntity attr : this.entity.getAttributes()) {
            result.add((Object)attr.getName(), (Object)attr.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public String getSingleAttribute(String name) {
        List values = this.getAttributes().getOrDefault(name, Collections.emptyList());
        if (values.isEmpty()) {
            return null;
        }
        return (String)values.get(0);
    }

    public List<String> getAttribute(String name) {
        List values = this.getAttributes().getOrDefault(name, Collections.emptyList());
        if (values.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(values);
    }

    public void setAttribute(String name, List<String> values) {
        this.removeAttribute(name);
        for (String value : values) {
            ResourceAttributeEntity attr = new ResourceAttributeEntity();
            attr.setId(KeycloakModelUtils.generateId());
            attr.setName(name);
            attr.setValue(value);
            attr.setResource(this.entity);
            this.em.persist((Object)attr);
            this.entity.getAttributes().add(attr);
        }
    }

    public void removeAttribute(String name) {
        this.throwExceptionIfReadonly();
        Query query = this.em.createNamedQuery("deleteResourceAttributesByNameAndResource");
        query.setParameter("name", (Object)name);
        query.setParameter("resourceId", (Object)this.entity.getId());
        query.executeUpdate();
        ArrayList<ResourceAttributeEntity> toRemove = new ArrayList<ResourceAttributeEntity>();
        for (ResourceAttributeEntity attr : this.entity.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            toRemove.add(attr);
        }
        this.entity.getAttributes().removeAll(toRemove);
    }

    public boolean isFetched(String association) {
        return this.em.getEntityManagerFactory().getPersistenceUnitUtil().isLoaded((Object)this.entity, association);
    }

    public static ResourceEntity toEntity(EntityManager em, Resource resource) {
        if (resource instanceof ResourceAdapter) {
            return ((ResourceAdapter)resource).getEntity();
        }
        return (ResourceEntity)em.getReference(ResourceEntity.class, (Object)resource.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Resource)) {
            return false;
        }
        Resource that = (Resource)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

