/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.models.ClientModel;
import org.keycloak.models.Constants;
import org.keycloak.representations.idm.ClientRepresentation;

public class OIDCAdvancedConfigWrapper {
    private final ClientModel clientModel;
    private final ClientRepresentation clientRep;

    private OIDCAdvancedConfigWrapper(ClientModel client, ClientRepresentation clientRep) {
        this.clientModel = client;
        this.clientRep = clientRep;
    }

    public static OIDCAdvancedConfigWrapper fromClientModel(ClientModel client) {
        return new OIDCAdvancedConfigWrapper(client, null);
    }

    public static OIDCAdvancedConfigWrapper fromClientRepresentation(ClientRepresentation clientRep) {
        return new OIDCAdvancedConfigWrapper(null, clientRep);
    }

    public Algorithm getUserInfoSignedResponseAlg() {
        String alg = this.getAttribute("user.info.response.signature.alg");
        return alg == null ? null : Enum.valueOf(Algorithm.class, alg);
    }

    public void setUserInfoSignedResponseAlg(Algorithm alg) {
        String algStr = alg == null ? null : alg.toString();
        this.setAttribute("user.info.response.signature.alg", algStr);
    }

    public boolean isUserInfoSignatureRequired() {
        return this.getUserInfoSignedResponseAlg() != null;
    }

    public Algorithm getRequestObjectSignatureAlg() {
        String alg = this.getAttribute("request.object.signature.alg");
        return alg == null ? null : Enum.valueOf(Algorithm.class, alg);
    }

    public void setRequestObjectSignatureAlg(Algorithm alg) {
        String algStr = alg == null ? null : alg.toString();
        this.setAttribute("request.object.signature.alg", algStr);
    }

    public void setRequestObjectEncryptionAlg(String algorithm) {
        this.setAttribute("request.object.encryption.alg", algorithm);
    }

    public String getRequestObjectEncryptionAlg() {
        return this.getAttribute("request.object.encryption.alg");
    }

    public String getRequestObjectEncryptionEnc() {
        return this.getAttribute("request.object.encryption.enc");
    }

    public void setRequestObjectEncryptionEnc(String algorithm) {
        this.setAttribute("request.object.encryption.enc", algorithm);
    }

    public String getRequestObjectRequired() {
        return this.getAttribute("request.object.required");
    }

    public void setRequestObjectRequired(String requestObjectRequired) {
        this.setAttribute("request.object.required", requestObjectRequired);
    }

    public List<String> getRequestUris() {
        return this.getAttributeMultivalued("request.uris");
    }

    public void setRequestUris(List<String> requestUris) {
        this.setAttributeMultivalued("request.uris", requestUris);
    }

    public boolean isUseJwksUrl() {
        String useJwksUrl = this.getAttribute("use.jwks.url");
        return Boolean.parseBoolean(useJwksUrl);
    }

    public void setUseJwksUrl(boolean useJwksUrl) {
        String val = String.valueOf(useJwksUrl);
        this.setAttribute("use.jwks.url", val);
    }

    public String getJwksUrl() {
        return this.getAttribute("jwks.url");
    }

    public void setJwksUrl(String jwksUrl) {
        this.setAttribute("jwks.url", jwksUrl);
    }

    public boolean isExcludeSessionStateFromAuthResponse() {
        String excludeSessionStateFromAuthResponse = this.getAttribute("exclude.session.state.from.auth.response");
        return Boolean.parseBoolean(excludeSessionStateFromAuthResponse);
    }

    public void setExcludeSessionStateFromAuthResponse(boolean excludeSessionStateFromAuthResponse) {
        String val = String.valueOf(excludeSessionStateFromAuthResponse);
        this.setAttribute("exclude.session.state.from.auth.response", val);
    }

    public boolean isUseMtlsHokToken() {
        String useUtlsHokToken = this.getAttribute("tls.client.certificate.bound.access.tokens");
        return Boolean.parseBoolean(useUtlsHokToken);
    }

    public void setUseMtlsHoKToken(boolean useUtlsHokToken) {
        String val = String.valueOf(useUtlsHokToken);
        this.setAttribute("tls.client.certificate.bound.access.tokens", val);
    }

    public boolean isUseRefreshToken() {
        String useRefreshToken = this.getAttribute("use.refresh.tokens", "true");
        return Boolean.parseBoolean(useRefreshToken);
    }

    public void setUseRefreshToken(boolean useRefreshToken) {
        String val = String.valueOf(useRefreshToken);
        this.setAttribute("use.refresh.tokens", val);
    }

    public boolean isUseRefreshTokenForClientCredentialsGrant() {
        String val = this.getAttribute("client_credentials.use_refresh_token", "false");
        return Boolean.parseBoolean(val);
    }

    public void setUseRefreshTokenForClientCredentialsGrant(boolean enable) {
        String val = String.valueOf(enable);
        this.setAttribute("client_credentials.use_refresh_token", val);
    }

    public String getTlsClientAuthSubjectDn() {
        return this.getAttribute("x509.subjectdn");
    }

    public void setTlsClientAuthSubjectDn(String tls_client_auth_subject_dn) {
        this.setAttribute("x509.subjectdn", tls_client_auth_subject_dn);
    }

    public String getPkceCodeChallengeMethod() {
        return this.getAttribute("pkce.code.challenge.method");
    }

    public void setPkceCodeChallengeMethod(String codeChallengeMethodName) {
        this.setAttribute("pkce.code.challenge.method", codeChallengeMethodName);
    }

    public String getIdTokenSignedResponseAlg() {
        return this.getAttribute("id.token.signed.response.alg");
    }

    public void setIdTokenSignedResponseAlg(String algName) {
        this.setAttribute("id.token.signed.response.alg", algName);
    }

    public String getIdTokenEncryptedResponseAlg() {
        return this.getAttribute("id.token.encrypted.response.alg");
    }

    public void setIdTokenEncryptedResponseAlg(String algName) {
        this.setAttribute("id.token.encrypted.response.alg", algName);
    }

    public String getIdTokenEncryptedResponseEnc() {
        return this.getAttribute("id.token.encrypted.response.enc");
    }

    public void setIdTokenEncryptedResponseEnc(String encName) {
        this.setAttribute("id.token.encrypted.response.enc", encName);
    }

    public String getAuthorizationSignedResponseAlg() {
        return this.getAttribute("authorization.signed.response.alg");
    }

    public void setAuthorizationSignedResponseAlg(String algName) {
        this.setAttribute("authorization.signed.response.alg", algName);
    }

    public String getAuthorizationEncryptedResponseAlg() {
        return this.getAttribute("authorization.encrypted.response.alg");
    }

    public void setAuthorizationEncryptedResponseAlg(String algName) {
        this.setAttribute("authorization.encrypted.response.alg", algName);
    }

    public String getAuthorizationEncryptedResponseEnc() {
        return this.getAttribute("authorization.encrypted.response.enc");
    }

    public void setAuthorizationEncryptedResponseEnc(String encName) {
        this.setAttribute("authorization.encrypted.response.enc", encName);
    }

    public String getTokenEndpointAuthSigningAlg() {
        return this.getAttribute("token.endpoint.auth.signing.alg");
    }

    public void setTokenEndpointAuthSigningAlg(String algName) {
        this.setAttribute("token.endpoint.auth.signing.alg", algName);
    }

    public String getBackchannelLogoutUrl() {
        return this.getAttribute("backchannel.logout.url");
    }

    public void setBackchannelLogoutUrl(String backchannelLogoutUrl) {
        this.setAttribute("backchannel.logout.url", backchannelLogoutUrl);
    }

    public boolean isBackchannelLogoutSessionRequired() {
        String backchannelLogoutSessionRequired = this.getAttribute("backchannel.logout.session.required");
        return Boolean.parseBoolean(backchannelLogoutSessionRequired);
    }

    public void setBackchannelLogoutSessionRequired(boolean backchannelLogoutSessionRequired) {
        String val = String.valueOf(backchannelLogoutSessionRequired);
        this.setAttribute("backchannel.logout.session.required", val);
    }

    public boolean getBackchannelLogoutRevokeOfflineTokens() {
        String backchannelLogoutRevokeOfflineTokens = this.getAttribute("backchannel.logout.revoke.offline.tokens");
        return Boolean.parseBoolean(backchannelLogoutRevokeOfflineTokens);
    }

    public void setBackchannelLogoutRevokeOfflineTokens(boolean backchannelLogoutRevokeOfflineTokens) {
        String val = String.valueOf(backchannelLogoutRevokeOfflineTokens);
        this.setAttribute("backchannel.logout.revoke.offline.tokens", val);
    }

    private String getAttribute(String attrKey) {
        if (this.clientModel != null) {
            return this.clientModel.getAttribute(attrKey);
        }
        return this.clientRep.getAttributes() == null ? null : (String)this.clientRep.getAttributes().get(attrKey);
    }

    private String getAttribute(String attrKey, String defaultValue) {
        String value = this.getAttribute(attrKey);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private void setAttribute(String attrKey, String attrValue) {
        if (this.clientModel != null) {
            if (attrValue != null) {
                this.clientModel.setAttribute(attrKey, attrValue);
            } else {
                this.clientModel.removeAttribute(attrKey);
            }
        } else if (attrValue != null) {
            if (this.clientRep.getAttributes() == null) {
                this.clientRep.setAttributes(new HashMap());
            }
            this.clientRep.getAttributes().put(attrKey, attrValue);
        } else if (this.clientRep.getAttributes() != null) {
            this.clientRep.getAttributes().put(attrKey, null);
        }
    }

    private List<String> getAttributeMultivalued(String attrKey) {
        String attrValue = this.getAttribute(attrKey);
        if (attrValue == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(Constants.CFG_DELIMITER_PATTERN.split(attrValue));
    }

    private void setAttributeMultivalued(String attrKey, List<String> attrValues) {
        if (attrValues == null || attrValues.size() == 0) {
            this.setAttribute(attrKey, null);
        } else {
            String attrValueFull = String.join((CharSequence)"##", attrValues);
            this.setAttribute(attrKey, attrValueFull);
        }
    }
}

