/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.util.Objects;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.ExplainedVerificationException;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.ExplainedTokenVerificationException;
import org.keycloak.common.VerificationException;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ActionTokenKeyModel;
import org.keycloak.models.ActionTokenStoreProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.LoginActionsServiceException;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

public class LoginActionsServiceChecks {
    private static final Logger LOG = Logger.getLogger((String)LoginActionsServiceChecks.class.getName());

    public static <T extends JsonWebToken> void checkNotLoggedInYet(ActionTokenContext<T> context, AuthenticationSessionModel authSessionFromCookie, String authSessionId) throws VerificationException {
        boolean hasNoRequiredActions;
        if (authSessionId == null) {
            return;
        }
        UserSessionModel userSession = context.getSession().sessions().getUserSession(context.getRealm(), authSessionId);
        boolean bl = hasNoRequiredActions = !(userSession != null && userSession.getUser().getRequiredActionsStream().count() != 0L || authSessionFromCookie != null && authSessionFromCookie.getRequiredActions() != null && !authSessionFromCookie.getRequiredActions().isEmpty());
        if (userSession != null && hasNoRequiredActions) {
            LoginFormsProvider loginForm = ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setAuthenticationSession(context.getAuthenticationSession()).setSuccess("alreadyLoggedIn", new Object[0]);
            if (context.getSession().getContext().getClient() == null) {
                loginForm.setAttribute("skipLink", (Object)true);
            }
            throw new LoginActionsServiceException(loginForm.createInfoPage());
        }
    }

    public static void checkIsUserValid(KeycloakSession session, RealmModel realm, String userId, Consumer<UserModel> userSetter) throws VerificationException {
        UserModel user;
        UserModel userModel = user = userId == null ? null : session.users().getUserById(realm, userId);
        if (user == null) {
            throw new ExplainedVerificationException("user_not_found", "invalidUserMessage");
        }
        if (!user.isEnabled()) {
            throw new ExplainedVerificationException("user_disabled", "invalidUserMessage");
        }
        if (userSetter != null) {
            userSetter.accept(user);
        }
    }

    public static <T extends JsonWebToken> void checkIsUserValid(T token, ActionTokenContext<T> context) throws VerificationException {
        try {
            LoginActionsServiceChecks.checkIsUserValid(context.getSession(), context.getRealm(), ((ActionTokenKeyModel)token).getUserId(), arg_0 -> ((AuthenticationSessionModel)context.getAuthenticationSession()).setAuthenticatedUser(arg_0));
        }
        catch (ExplainedVerificationException ex) {
            throw new ExplainedTokenVerificationException(token, ex);
        }
    }

    public static void checkIsClientValid(KeycloakSession session, ClientModel client) throws VerificationException {
        if (client == null) {
            throw new ExplainedVerificationException("client_not_found", "unknownLoginRequesterMessage");
        }
        if (!client.isEnabled()) {
            throw new ExplainedVerificationException("client_not_found", "loginRequesterNotEnabledMessage");
        }
    }

    public static <T extends JsonWebToken> void checkIsClientValid(T token, ActionTokenContext<T> context) throws VerificationException {
        String clientId = token.getIssuedFor();
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        ClientModel client = authSession == null ? null : authSession.getClient();
        try {
            LoginActionsServiceChecks.checkIsClientValid(context.getSession(), client);
            if (clientId != null && !Objects.equals(client.getClientId(), clientId)) {
                throw new ExplainedTokenVerificationException(token, "client_not_found", "unknownLoginRequesterMessage");
            }
        }
        catch (ExplainedVerificationException ex) {
            throw new ExplainedTokenVerificationException(token, ex);
        }
    }

    public static <T extends JsonWebToken> boolean doesAuthenticationSessionFromCookieMatchOneFromToken(ActionTokenContext<T> context, AuthenticationSessionModel authSessionFromCookie, String authSessionCompoundIdFromToken) throws VerificationException {
        if (authSessionCompoundIdFromToken == null) {
            return false;
        }
        if (Objects.equals(AuthenticationSessionCompoundId.fromAuthSession((AuthenticationSessionModel)authSessionFromCookie).getEncodedId(), authSessionCompoundIdFromToken)) {
            context.setAuthenticationSession(authSessionFromCookie, false);
            return true;
        }
        String parentTabId = authSessionFromCookie.getAuthNote("forked.from");
        if (parentTabId == null) {
            return false;
        }
        AuthenticationSessionModel authSessionFromParent = authSessionFromCookie.getParentSession().getAuthenticationSession(authSessionFromCookie.getClient(), parentTabId);
        if (authSessionFromParent == null) {
            return false;
        }
        LOG.debugf("Switched to forked tab: %s from: %s . Root session: %s", (Object)authSessionFromParent.getTabId(), (Object)authSessionFromCookie.getTabId(), (Object)authSessionFromCookie.getParentSession().getId());
        context.setAuthenticationSession(authSessionFromParent, false);
        context.setExecutionId(authSessionFromParent.getAuthNote("last.processed.execution"));
        return true;
    }

    public static <T extends JsonWebToken> void checkTokenWasNotUsedYet(T token, ActionTokenContext<T> context) throws VerificationException {
        ActionTokenStoreProvider actionTokenStore = (ActionTokenStoreProvider)context.getSession().getProvider(ActionTokenStoreProvider.class);
        if (actionTokenStore.get((ActionTokenKeyModel)token) != null) {
            throw new ExplainedTokenVerificationException(token, "expired_code", "expiredActionMessage");
        }
    }

    public static class IsRedirectValid
    implements TokenVerifier.Predicate<JsonWebToken> {
        private final ActionTokenContext<?> context;
        private final String redirectUri;

        public IsRedirectValid(ActionTokenContext<?> context, String redirectUri) {
            this.context = context;
            this.redirectUri = redirectUri;
        }

        public boolean test(JsonWebToken t) throws VerificationException {
            if (this.redirectUri == null) {
                return true;
            }
            ClientModel client = this.context.getAuthenticationSession().getClient();
            if (RedirectUtils.verifyRedirectUri(this.context.getSession(), this.redirectUri, client) == null) {
                throw new ExplainedTokenVerificationException(t, "invalid_redirect_uri", "invalidRedirectUriMessage");
            }
            return true;
        }
    }

    public static class IsActionRequired
    implements TokenVerifier.Predicate<JsonWebToken> {
        private final ActionTokenContext<?> context;
        private final CommonClientSessionModel.Action expectedAction;

        public IsActionRequired(ActionTokenContext<?> context, CommonClientSessionModel.Action expectedAction) {
            this.context = context;
            this.expectedAction = expectedAction;
        }

        public boolean test(JsonWebToken t) throws VerificationException {
            AuthenticationSessionModel authSession = this.context.getAuthenticationSession();
            if (authSession != null && !Objects.equals(authSession.getAction(), this.expectedAction.name())) {
                if (Objects.equals(CommonClientSessionModel.Action.REQUIRED_ACTIONS.name(), authSession.getAction())) {
                    throw new LoginActionsServiceException(AuthenticationManager.nextActionAfterAuthentication(this.context.getSession(), authSession, this.context.getClientConnection(), this.context.getRequest(), this.context.getUriInfo(), this.context.getEvent()));
                }
                throw new ExplainedTokenVerificationException(t, "invalid_token", "invalidCodeMessage");
            }
            return true;
        }
    }

    public static class AuthenticationSessionUserIdMatchesOneFromToken
    implements TokenVerifier.Predicate<JsonWebToken> {
        private final ActionTokenContext<?> context;

        public AuthenticationSessionUserIdMatchesOneFromToken(ActionTokenContext<?> context) {
            this.context = context;
        }

        public boolean test(JsonWebToken t) throws VerificationException {
            AuthenticationSessionModel authSession = this.context.getAuthenticationSession();
            if (authSession == null || authSession.getAuthenticatedUser() == null || !Objects.equals(t.getSubject(), authSession.getAuthenticatedUser().getId())) {
                throw new ExplainedTokenVerificationException(t, "invalid_token", "invalidUserMessage");
            }
            return true;
        }
    }
}

