/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PushedAuthzRequestStoreProvider;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanPushedAuthzRequestStoreProvider
implements PushedAuthzRequestStoreProvider {
    public static final Logger logger = Logger.getLogger(InfinispanPushedAuthzRequestStoreProvider.class);
    private final Supplier<BasicCache<UUID, ActionTokenValueEntity>> parDataCache;

    public InfinispanPushedAuthzRequestStoreProvider(KeycloakSession session, Supplier<BasicCache<UUID, ActionTokenValueEntity>> actionKeyCache) {
        this.parDataCache = actionKeyCache;
    }

    public void put(UUID key, int lifespanSeconds, Map<String, String> codeData) {
        ActionTokenValueEntity tokenValue = new ActionTokenValueEntity(codeData);
        try {
            BasicCache<UUID, ActionTokenValueEntity> cache = this.parDataCache.get();
            long lifespanMs = InfinispanUtil.toHotrodTimeMs(cache, Time.toMillis((long)lifespanSeconds));
            cache.put((Object)key, (Object)tokenValue, lifespanMs, TimeUnit.MILLISECONDS);
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when adding PAR data for redirect URI: %s", (Object)key);
            }
            throw re;
        }
    }

    public Map<String, String> remove(UUID key) {
        try {
            BasicCache<UUID, ActionTokenValueEntity> cache = this.parDataCache.get();
            ActionTokenValueEntity existing = (ActionTokenValueEntity)cache.remove((Object)key);
            return existing == null ? null : existing.getNotes();
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when removing PAR data for redirect URI %s", (Object)key);
            }
            return null;
        }
    }

    public void close() {
    }
}

