/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.function.Supplier;
import org.infinispan.commons.api.BasicCache;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.TokenRevocationStoreProvider;
import org.keycloak.models.TokenRevocationStoreProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanSingleUseTokenStoreProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanTokenRevocationStoreProvider;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanTokenRevocationStoreProviderFactory
implements TokenRevocationStoreProviderFactory {
    private volatile Supplier<BasicCache<String, ActionTokenValueEntity>> tokenCache;

    public TokenRevocationStoreProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanTokenRevocationStoreProvider(session, this.tokenCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.tokenCache == null) {
            InfinispanTokenRevocationStoreProviderFactory infinispanTokenRevocationStoreProviderFactory = this;
            synchronized (infinispanTokenRevocationStoreProviderFactory) {
                if (this.tokenCache == null) {
                    this.tokenCache = InfinispanSingleUseTokenStoreProviderFactory.getActionTokenCache(session);
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }

    public int order() {
        return 1;
    }
}

