/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;

@SerializeWith(value=ExternalizerImpl.class)
public class ActionTokenReducedKey
implements Serializable {
    private final String userId;
    private final String actionId;
    private final UUID actionVerificationNonce;

    public ActionTokenReducedKey(String userId, String actionId, UUID actionVerificationNonce) {
        this.userId = userId;
        this.actionId = actionId;
        this.actionVerificationNonce = actionVerificationNonce;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getActionId() {
        return this.actionId;
    }

    public UUID getActionVerificationNonce() {
        return this.actionVerificationNonce;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.userId);
        hash = 71 * hash + Objects.hashCode(this.actionId);
        hash = 71 * hash + Objects.hashCode(this.actionVerificationNonce);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionTokenReducedKey other = (ActionTokenReducedKey)obj;
        return Objects.equals(this.userId, other.getUserId()) && Objects.equals(this.actionId, other.getActionId()) && Objects.equals(this.actionVerificationNonce, other.getActionVerificationNonce());
    }

    public String toString() {
        return "userId=" + this.userId + ", actionId=" + this.actionId + ", actionVerificationNonce=" + this.actionVerificationNonce;
    }

    public static class ExternalizerImpl
    implements Externalizer<ActionTokenReducedKey> {
        public void writeObject(ObjectOutput output, ActionTokenReducedKey t) throws IOException {
            output.writeUTF(t.userId);
            output.writeUTF(t.actionId);
            output.writeLong(t.actionVerificationNonce.getMostSignificantBits());
            output.writeLong(t.actionVerificationNonce.getLeastSignificantBits());
        }

        public ActionTokenReducedKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new ActionTokenReducedKey(input.readUTF(), input.readUTF(), new UUID(input.readLong(), input.readLong()));
        }
    }
}

