/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class RootAuthenticationSessionEntity
extends SessionEntity {
    private String id;
    private int timestamp;
    private Map<String, AuthenticationSessionEntity> authenticationSessions = new ConcurrentHashMap<String, AuthenticationSessionEntity>();

    public RootAuthenticationSessionEntity() {
    }

    protected RootAuthenticationSessionEntity(String realmId, String id, int timestamp, Map<String, AuthenticationSessionEntity> authenticationSessions) {
        super(realmId);
        this.id = id;
        this.timestamp = timestamp;
        this.authenticationSessions = authenticationSessions;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public Map<String, AuthenticationSessionEntity> getAuthenticationSessions() {
        return this.authenticationSessions;
    }

    public void setAuthenticationSessions(Map<String, AuthenticationSessionEntity> authenticationSessions) {
        this.authenticationSessions = authenticationSessions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RootAuthenticationSessionEntity)) {
            return false;
        }
        RootAuthenticationSessionEntity that = (RootAuthenticationSessionEntity)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    @Override
    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return String.format("RootAuthenticationSessionEntity [ id=%s, realm=%s ]", this.getId(), this.getRealmId());
    }

    public static class ExternalizerImpl
    implements Externalizer<RootAuthenticationSessionEntity> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, RootAuthenticationSessionEntity value) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)value.getRealmId(), (ObjectOutput)output);
            MarshallUtil.marshallString((String)value.id, (ObjectOutput)output);
            output.writeInt(value.timestamp);
            KeycloakMarshallUtil.writeMap(value.authenticationSessions, KeycloakMarshallUtil.STRING_EXT, AuthenticationSessionEntity.ExternalizerImpl.INSTANCE, output);
        }

        public RootAuthenticationSessionEntity readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public RootAuthenticationSessionEntity readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            return new RootAuthenticationSessionEntity(MarshallUtil.unmarshallString((ObjectInput)input), MarshallUtil.unmarshallString((ObjectInput)input), input.readInt(), (Map<String, AuthenticationSessionEntity>)KeycloakMarshallUtil.readMap(input, KeycloakMarshallUtil.STRING_EXT, AuthenticationSessionEntity.ExternalizerImpl.INSTANCE, size -> new ConcurrentHashMap(size)));
        }
    }
}

