/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.keycloak.subsystem.server.extension.KeycloakExtension;
import org.keycloak.subsystem.server.extension.KeycloakSubsystemDefinition;
import org.keycloak.subsystem.server.extension.ProviderResourceDefinition;
import org.keycloak.subsystem.server.extension.SpiResourceDefinition;
import org.keycloak.subsystem.server.extension.ThemeResourceDefinition;

class KeycloakSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    KeycloakSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode addKeycloakSub = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{KeycloakExtension.PATH_SUBSYSTEM}));
        list.add(addKeycloakSub);
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            if (reader.getLocalName().equals(KeycloakSubsystemDefinition.WEB_CONTEXT.getXmlName())) {
                KeycloakSubsystemDefinition.WEB_CONTEXT.parseAndSetParameter(reader.getElementText(), addKeycloakSub, (XMLStreamReader)reader);
                continue;
            }
            if (reader.getLocalName().equals(KeycloakSubsystemDefinition.PROVIDERS.getXmlName())) {
                this.readProviders(reader, addKeycloakSub);
                continue;
            }
            if (reader.getLocalName().equals(KeycloakSubsystemDefinition.MASTER_REALM_NAME.getXmlName())) {
                KeycloakSubsystemDefinition.MASTER_REALM_NAME.parseAndSetParameter(reader.getElementText(), addKeycloakSub, (XMLStreamReader)reader);
                continue;
            }
            if (reader.getLocalName().equals(KeycloakSubsystemDefinition.SCHEDULED_TASK_INTERVAL.getXmlName())) {
                KeycloakSubsystemDefinition.SCHEDULED_TASK_INTERVAL.parseAndSetParameter(reader.getElementText(), addKeycloakSub, (XMLStreamReader)reader);
                continue;
            }
            if (reader.getLocalName().equals("theme")) {
                this.readTheme(list, reader);
                continue;
            }
            if (reader.getLocalName().equals("spi")) {
                this.readSpi(list, reader);
                continue;
            }
            throw new XMLStreamException("Unknown keycloak-server subsystem tag: " + reader.getLocalName());
        }
    }

    private void readProviders(XMLExtendedStreamReader reader, ModelNode addKeycloakSub) throws XMLStreamException {
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            KeycloakSubsystemDefinition.PROVIDERS.parseAndAddParameterElement(reader.getElementText(), addKeycloakSub, (XMLStreamReader)reader);
        }
    }

    private void readTheme(List<ModelNode> list, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode addThemeDefaults = new ModelNode();
        addThemeDefaults.get("operation").set("add");
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"keycloak-server"), PathElement.pathElement((String)"theme", (String)"defaults")});
        addThemeDefaults.get("address").set(addr.toModelNode());
        list.add(addThemeDefaults);
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            String tagName = reader.getLocalName();
            if (ThemeResourceDefinition.MODULES.getName().equals(tagName)) {
                this.readModules(reader, addThemeDefaults);
                continue;
            }
            SimpleAttributeDefinition def = ThemeResourceDefinition.lookup(tagName);
            if (def == null) {
                throw new XMLStreamException("Unknown theme tag " + tagName);
            }
            def.parseAndSetParameter(reader.getElementText(), addThemeDefaults, (XMLStreamReader)reader);
        }
    }

    private void readModules(XMLExtendedStreamReader reader, ModelNode addThemeDefaults) throws XMLStreamException {
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            ThemeResourceDefinition.MODULES.parseAndAddParameterElement(reader.getElementText(), addThemeDefaults, (XMLStreamReader)reader);
        }
    }

    private void readSpi(List<ModelNode> list, XMLExtendedStreamReader reader) throws XMLStreamException {
        String spiName = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{"name"})[0];
        ModelNode addSpi = new ModelNode();
        addSpi.get("operation").set("add");
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"keycloak-server"), PathElement.pathElement((String)"spi", (String)spiName)});
        addSpi.get("address").set(addr.toModelNode());
        list.add(addSpi);
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            if (reader.getLocalName().equals(SpiResourceDefinition.DEFAULT_PROVIDER.getXmlName())) {
                SpiResourceDefinition.DEFAULT_PROVIDER.parseAndSetParameter(reader.getElementText(), addSpi, (XMLStreamReader)reader);
                continue;
            }
            if (!reader.getLocalName().equals("provider")) continue;
            this.readProvider(list, spiName, reader);
        }
    }

    private void readProvider(List<ModelNode> list, String spiName, XMLExtendedStreamReader reader) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{"name", ProviderResourceDefinition.ENABLED.getXmlName()});
        String providerName = attributes[0];
        String enabled = attributes[1];
        ModelNode addProvider = new ModelNode();
        addProvider.get("operation").set("add");
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"keycloak-server"), PathElement.pathElement((String)"spi", (String)spiName), PathElement.pathElement((String)"provider", (String)providerName)});
        addProvider.get("address").set(addr.toModelNode());
        addProvider.get(ProviderResourceDefinition.ENABLED.getName()).set(Boolean.valueOf(enabled).booleanValue());
        list.add(addProvider);
        while (this.nextTag(reader) != 2) {
            if (!reader.getLocalName().equals(ProviderResourceDefinition.PROPERTIES.getXmlName())) continue;
            this.readProperties(ProviderResourceDefinition.PROPERTIES, addProvider, reader);
        }
    }

    private void readProperties(PropertiesAttributeDefinition attrDef, ModelNode addOp, XMLExtendedStreamReader reader) throws XMLStreamException {
        while (this.nextTag(reader) != 2) {
            int attrCount = reader.getAttributeCount();
            if (attrCount != 2) {
                throw new XMLStreamException("Property must have only two attributes");
            }
            String name = "";
            String value = "";
            for (int i = 0; i < 2; ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                if (attrName.equals("name")) {
                    name = attrValue;
                    continue;
                }
                if (attrName.equals("value")) {
                    value = attrValue;
                    continue;
                }
                throw new XMLStreamException("Property can only have attributes named 'name' and 'value'");
            }
            attrDef.parseAndAddParameterElement(name, value, addOp, reader);
            this.nextTag(reader);
        }
    }

    private int nextTag(XMLExtendedStreamReader reader) throws XMLStreamException {
        return reader.nextTag();
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement("urn:jboss:domain:keycloak-server:1.1", false);
        this.writeWebContext(writer, context);
        this.writeList(writer, context.getModelNode(), (AttributeDefinition)KeycloakSubsystemDefinition.PROVIDERS, "provider");
        this.writeAdmin(writer, context);
        this.writeScheduledTaskInterval(writer, context);
        this.writeThemeDefaults(writer, context);
        this.writeSpis(writer, context);
        writer.writeEndElement();
    }

    private void writeThemeDefaults(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        if (!context.getModelNode().get("theme").isDefined()) {
            return;
        }
        writer.writeStartElement("theme");
        ModelNode themeElements = context.getModelNode().get(new String[]{"theme", "defaults"});
        for (AttributeDefinition def : ThemeResourceDefinition.ALL_ATTRIBUTES) {
            if (!themeElements.hasDefined(def.getName())) continue;
            if (def == ThemeResourceDefinition.MODULES) {
                ModelNode themeContext = context.getModelNode().get(new String[]{"theme", "defaults"});
                this.writeList(writer, themeContext, def, "module");
                continue;
            }
            def.marshallAsElement(themeElements, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    private void writeSpis(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        if (!context.getModelNode().get("spi").isDefined()) {
            return;
        }
        for (Property spi : context.getModelNode().get("spi").asPropertyList()) {
            writer.writeStartElement("spi");
            writer.writeAttribute("name", spi.getName());
            ModelNode spiElements = spi.getValue();
            SpiResourceDefinition.DEFAULT_PROVIDER.marshallAsElement(spiElements, (XMLStreamWriter)writer);
            this.writeProviders(writer, spiElements);
            writer.writeEndElement();
        }
    }

    private void writeProviders(XMLExtendedStreamWriter writer, ModelNode spiElements) throws XMLStreamException {
        if (!spiElements.get("provider").isDefined()) {
            return;
        }
        for (Property provider : spiElements.get("provider").asPropertyList()) {
            writer.writeStartElement("provider");
            writer.writeAttribute("name", provider.getName());
            ModelNode providerElements = provider.getValue();
            ProviderResourceDefinition.ENABLED.marshallAsAttribute(providerElements, (XMLStreamWriter)writer);
            ProviderResourceDefinition.PROPERTIES.marshallAsElement(providerElements, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeWebContext(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        if (!context.getModelNode().get(KeycloakSubsystemDefinition.WEB_CONTEXT.getName()).isDefined()) {
            return;
        }
        KeycloakSubsystemDefinition.WEB_CONTEXT.marshallAsElement(context.getModelNode(), (XMLStreamWriter)writer);
    }

    private void writeAdmin(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        if (!context.getModelNode().get(KeycloakSubsystemDefinition.MASTER_REALM_NAME.getName()).isDefined()) {
            return;
        }
        KeycloakSubsystemDefinition.MASTER_REALM_NAME.marshallAsElement(context.getModelNode(), (XMLStreamWriter)writer);
    }

    private void writeScheduledTaskInterval(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        if (!context.getModelNode().get(KeycloakSubsystemDefinition.SCHEDULED_TASK_INTERVAL.getName()).isDefined()) {
            return;
        }
        KeycloakSubsystemDefinition.SCHEDULED_TASK_INTERVAL.marshallAsElement(context.getModelNode(), (XMLStreamWriter)writer);
    }

    private void writeList(XMLExtendedStreamWriter writer, ModelNode context, AttributeDefinition def, String elementName) throws XMLStreamException {
        if (!context.get(def.getName()).isDefined()) {
            return;
        }
        writer.writeStartElement(def.getXmlName());
        ModelNode modules = context.get(def.getName());
        for (ModelNode module : modules.asList()) {
            writer.writeStartElement(elementName);
            writer.writeCharacters(module.asString());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

