/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.data.extension.client.UnknownExtensionClientInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationExtensionClientInputDeserializer
extends StdDeserializer<RegistrationExtensionClientInput<?>> {
    private final transient Logger logger = LoggerFactory.getLogger(RegistrationExtensionClientInputDeserializer.class);

    public RegistrationExtensionClientInputDeserializer() {
        super(RegistrationExtensionClientInput.class);
    }

    public RegistrationExtensionClientInput<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String name = p.getParsingContext().getCurrentName();
        if (name == null) {
            name = p.getParsingContext().getParent().getCurrentName();
        }
        DeserializationConfig config = ctxt.getConfig();
        AnnotatedClass annotatedClass = AnnotatedClassResolver.resolveWithoutSuperTypes((MapperConfig)config, RegistrationExtensionClientInput.class);
        Collection namedTypes = config.getSubtypeResolver().collectAndResolveSubtypesByClass((MapperConfig)config, annotatedClass);
        for (NamedType namedType : namedTypes) {
            if (!Objects.equals(namedType.getName(), name)) continue;
            return (RegistrationExtensionClientInput)ctxt.readValue(p, namedType.getType());
        }
        this.logger.warn("Unknown extension '{}' is contained.", (Object)name);
        return (RegistrationExtensionClientInput)ctxt.readValue(p, UnknownExtensionClientInput.class);
    }
}

