/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class AuthenticationData
implements Serializable {
    private final byte[] credentialId;
    private final byte[] userHandle;
    private final AuthenticatorData<AuthenticationExtensionAuthenticatorOutput<?>> authenticatorData;
    private final byte[] authenticatorDataBytes;
    private final CollectedClientData collectedClientData;
    private final byte[] collectedClientDataBytes;
    private final AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput<?>> clientExtensions;
    private final byte[] signature;

    public AuthenticationData(byte[] credentialId, byte[] userHandle, AuthenticatorData<AuthenticationExtensionAuthenticatorOutput<?>> authenticatorData, byte[] authenticatorDataBytes, CollectedClientData collectedClientData, byte[] collectedClientDataBytes, AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput<?>> clientExtensions, byte[] signature) {
        this.credentialId = ArrayUtil.clone((byte[])credentialId);
        this.userHandle = ArrayUtil.clone((byte[])userHandle);
        this.authenticatorData = authenticatorData;
        this.authenticatorDataBytes = ArrayUtil.clone((byte[])authenticatorDataBytes);
        this.collectedClientData = collectedClientData;
        this.collectedClientDataBytes = ArrayUtil.clone((byte[])collectedClientDataBytes);
        this.clientExtensions = clientExtensions;
        this.signature = ArrayUtil.clone((byte[])signature);
    }

    public byte[] getCredentialId() {
        return ArrayUtil.clone((byte[])this.credentialId);
    }

    public byte[] getUserHandle() {
        return ArrayUtil.clone((byte[])this.userHandle);
    }

    public AuthenticatorData<AuthenticationExtensionAuthenticatorOutput<?>> getAuthenticatorData() {
        return this.authenticatorData;
    }

    public byte[] getAuthenticatorDataBytes() {
        return ArrayUtil.clone((byte[])this.authenticatorDataBytes);
    }

    public CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    public byte[] getCollectedClientDataBytes() {
        return ArrayUtil.clone((byte[])this.collectedClientDataBytes);
    }

    public AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput<?>> getClientExtensions() {
        return this.clientExtensions;
    }

    public byte[] getSignature() {
        return ArrayUtil.clone((byte[])this.signature);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationData that = (AuthenticationData)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Arrays.equals(this.userHandle, that.userHandle) && Objects.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.authenticatorDataBytes, that.authenticatorDataBytes) && Objects.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.collectedClientDataBytes, that.collectedClientDataBytes) && Objects.equals(this.clientExtensions, that.clientExtensions) && Arrays.equals(this.signature, that.signature);
    }

    public int hashCode() {
        int result = Objects.hash(this.authenticatorData, this.collectedClientData, this.clientExtensions);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        result = 31 * result + Arrays.hashCode(this.userHandle);
        result = 31 * result + Arrays.hashCode(this.authenticatorDataBytes);
        result = 31 * result + Arrays.hashCode(this.collectedClientDataBytes);
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }
}

