/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.capability.CapabilityInitializer;
import com.openshift.internal.restclient.model.Container;
import com.openshift.internal.restclient.model.EnvironmentVariable;
import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.Port;
import com.openshift.internal.restclient.model.volume.EmptyDirVolumeSource;
import com.openshift.internal.restclient.model.volume.VolumeMount;
import com.openshift.internal.restclient.model.volume.VolumeSource;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.IClient;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IContainer;
import com.openshift.restclient.model.IEnvironmentVariable;
import com.openshift.restclient.model.IPort;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.volume.IVolumeMount;
import com.openshift.restclient.model.volume.IVolumeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReplicationController
extends KubernetesResource
implements IReplicationController {
    public static final String SPEC_TEMPLATE_CONTAINERS = "spec.template.spec.containers";
    protected static final String SPEC_TEMPLATE_LABELS = "spec.template.metadata.labels";
    protected static final String VOLUMES = "spec.template.spec.volumes";
    protected static final String SPEC_REPLICAS = "spec.replicas";
    protected static final String SPEC_SELECTOR = "spec.selector";
    protected static final String STATUS_REPLICA = "status.replicas";
    protected static final String SERVICEACCOUNTNAME = "spec.template.spec.serviceAccountName";
    protected static final String IMAGE = "image";
    protected static final String ENV = "env";
    private Map<String, String[]> propertyKeys;

    public ReplicationController(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
        this.propertyKeys = propertyKeys;
        CapabilityInitializer.initializeCapabilities(this.getModifiableCapabilities(), this, this.getClient());
    }

    @Override
    public void setEnvironmentVariable(String name, String value) {
        this.setEnvironmentVariable(null, name, value);
    }

    @Override
    public void setEnvironmentVariable(String containerName, String name, String value) {
        List containers;
        String defaultedContainerName = StringUtils.defaultIfBlank((String)containerName, (String)"");
        ModelNode specContainers = this.get(SPEC_TEMPLATE_CONTAINERS);
        if (specContainers.isDefined() && !(containers = specContainers.asList()).isEmpty()) {
            Optional<ModelNode> targetVar;
            Optional<ModelNode> opt = containers.stream().filter(n -> defaultedContainerName.equals(this.asString((ModelNode)n, "name"))).findFirst();
            ModelNode node = opt.isPresent() ? opt.get() : (ModelNode)containers.get(0);
            ModelNode envNode = this.get(node, ENV);
            ArrayList<ModelNode> varList = new ArrayList<ModelNode>();
            if (ModelType.LIST.equals((Object)envNode.getType())) {
                varList.addAll(envNode.asList());
            }
            if ((targetVar = varList.stream().filter(n -> name.equals(this.asString((ModelNode)n, "name"))).findFirst()).isPresent()) {
                ModelNode var = targetVar.get();
                int i = varList.indexOf(var);
                this.set(var, "value", value);
                varList.set(i, var);
            } else {
                ModelNode var = new ModelNode();
                this.set(var, "name", name);
                this.set(var, "value", value);
                varList.add(var);
            }
            envNode.set(varList);
        }
    }

    @Override
    public void removeEnvironmentVariable(String name) {
        this.removeEnvironmentVariable(null, name);
    }

    @Override
    public void removeEnvironmentVariable(String containerName, String name) {
        List containers;
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null.");
        }
        String defaultedContainerName = StringUtils.defaultIfBlank((String)containerName, (String)"");
        ModelNode specContainers = this.get(SPEC_TEMPLATE_CONTAINERS);
        if (specContainers.isDefined() && !(containers = specContainers.asList()).isEmpty()) {
            Optional<ModelNode> targetVar;
            Optional<ModelNode> opt = containers.stream().filter(n -> defaultedContainerName.equals(this.asString((ModelNode)n, "name"))).findFirst();
            ModelNode node = opt.isPresent() ? opt.get() : (ModelNode)containers.get(0);
            ModelNode envNode = this.get(node, ENV);
            ArrayList varList = new ArrayList();
            if (ModelType.LIST.equals((Object)envNode.getType())) {
                varList.addAll(envNode.asList());
            }
            if ((targetVar = varList.stream().filter(n -> name.equals(this.asString((ModelNode)n, "name"))).findFirst()).isPresent()) {
                ModelNode var = targetVar.get();
                int i = varList.indexOf(var);
                varList.remove(i);
                envNode.set(varList);
            }
        }
    }

    @Override
    public Collection<IEnvironmentVariable> getEnvironmentVariables() {
        return this.getEnvironmentVariables(null);
    }

    @Override
    public Collection<IEnvironmentVariable> getEnvironmentVariables(String containerName) {
        Optional<ModelNode> opt;
        ModelNode node;
        ModelNode envNode;
        List containers;
        String name = StringUtils.defaultIfBlank((String)containerName, (String)"");
        ModelNode specContainers = this.get(SPEC_TEMPLATE_CONTAINERS);
        if (specContainers.isDefined() && !(containers = specContainers.asList()).isEmpty() && (envNode = this.get(node = (opt = containers.stream().filter(n -> name.equals(this.asString((ModelNode)n, "name"))).findFirst()).isPresent() ? opt.get() : (ModelNode)containers.get(0), ENV)).isDefined()) {
            return envNode.asList().stream().map(n -> new EnvironmentVariable((ModelNode)n, this.propertyKeys)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public int getDesiredReplicaCount() {
        return this.asInt(SPEC_REPLICAS);
    }

    @Override
    public int getReplicas() {
        return this.getDesiredReplicaCount();
    }

    @Override
    public void setDesiredReplicaCount(int count) {
        this.set(SPEC_REPLICAS, count);
    }

    @Override
    public void setReplicas(int count) {
        this.setDesiredReplicaCount(count);
    }

    @Override
    public Map<String, String> getReplicaSelector() {
        return this.asMap(SPEC_SELECTOR);
    }

    @Override
    public void setReplicaSelector(String key, String value) {
        HashMap<String, String> selector = new HashMap<String, String>();
        selector.put(key, value);
        this.setReplicaSelector(selector);
    }

    @Override
    public void setReplicaSelector(Map<String, String> selector) {
        this.get(SPEC_SELECTOR).clear();
        this.set(SPEC_SELECTOR, selector);
        selector.forEach((k, v) -> this.addTemplateLabel((String)k, (String)v));
    }

    @Override
    public int getCurrentReplicaCount() {
        return this.asInt(STATUS_REPLICA);
    }

    @Override
    public Collection<String> getImages() {
        ModelNode node = this.get(SPEC_TEMPLATE_CONTAINERS);
        if (node.getType() != ModelType.LIST) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (ModelNode entry : node.asList()) {
            list.add(entry.get(IMAGE).asString());
        }
        return list;
    }

    @Override
    public IContainer getContainer(String name) {
        Optional<ModelNode> first;
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        ModelNode containers = this.get(SPEC_TEMPLATE_CONTAINERS);
        if (containers.isDefined() && containers.getType() == ModelType.LIST && (first = containers.asList().stream().filter(n -> name.equals(JBossDmrExtentions.asString(n, this.propertyKeys, "name"))).findFirst()).isPresent()) {
            return new Container(first.get(), this.propertyKeys);
        }
        return null;
    }

    @Override
    public Collection<IContainer> getContainers() {
        ModelNode containers = this.get(SPEC_TEMPLATE_CONTAINERS);
        if (containers.isDefined() && containers.getType() == ModelType.LIST) {
            return containers.asList().stream().map(n -> new Container((ModelNode)n, this.propertyKeys)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> getTemplateLabels() {
        return this.asMap(SPEC_TEMPLATE_LABELS);
    }

    @Override
    public void addTemplateLabel(String key, String value) {
        ModelNode labels = this.get(SPEC_TEMPLATE_LABELS);
        labels.get(key).set(value);
    }

    @Override
    public IContainer addContainer(DockerImageURI tag, Set<IPort> containerPorts, Map<String, String> envVars) {
        return this.addContainer(tag.getName(), tag, containerPorts, envVars, new ArrayList<String>());
    }

    @Override
    public IContainer addContainer(String name, DockerImageURI tag, Set<IPort> containerPorts, Map<String, String> envVars, List<String> emptyDirVolumes) {
        IContainer container = this.addContainer(name);
        container.setImage(tag);
        if (!emptyDirVolumes.isEmpty()) {
            HashSet<IVolumeMount> volumes = new HashSet<IVolumeMount>();
            for (String path : emptyDirVolumes) {
                VolumeMount volume = new VolumeMount(new ModelNode());
                volume.setMountPath(path);
                volume.setName(String.format("%s-%s", name, emptyDirVolumes.indexOf(path) + 1));
                volumes.add(volume);
                this.addEmptyDirVolumeToPodSpec(volume);
            }
            container.setVolumeMounts(volumes);
        }
        if (!containerPorts.isEmpty()) {
            HashSet<IPort> ports = new HashSet<IPort>();
            for (IPort port : containerPorts) {
                ports.add(new Port(new ModelNode(), port));
            }
            container.setPorts(ports);
        }
        container.setEnvVars(envVars);
        return container;
    }

    @Override
    public IContainer addContainer(String name) {
        ModelNode containers = this.get(SPEC_TEMPLATE_CONTAINERS);
        Container container = new Container(containers.add());
        container.setName(name);
        return container;
    }

    private boolean hasVolumeNamed(ModelNode volNode, String name) {
        if (volNode.isDefined()) {
            List podVolumes = volNode.asList();
            for (ModelNode node : podVolumes) {
                if (!name.equals(this.asString(node, "name"))) continue;
                return true;
            }
        }
        return false;
    }

    private void addEmptyDirVolumeToPodSpec(VolumeMount volume) {
        ModelNode volNode = this.get(VOLUMES);
        if (this.hasVolumeNamed(volNode, volume.getName())) {
            return;
        }
        EmptyDirVolumeSource volumeSource = new EmptyDirVolumeSource(volume.getName());
        volumeSource.setMedium("");
        this.addVolume(volumeSource);
    }

    @Override
    public void setContainers(Collection<IContainer> containers) {
        ModelNode nodeContainers = this.get(SPEC_TEMPLATE_CONTAINERS);
        nodeContainers.clear();
        if (containers != null) {
            containers.forEach(c -> nodeContainers.add(ModelNode.fromJSONString((String)c.toJson())));
        }
    }

    @Override
    public Set<IVolumeSource> getVolumes() {
        ModelNode vol = this.get(VOLUMES);
        HashSet<IVolumeSource> volumes = new HashSet<IVolumeSource>();
        if (vol.isDefined()) {
            for (ModelNode node : vol.asList()) {
                volumes.add(VolumeSource.create(node));
            }
        }
        return volumes;
    }

    @Override
    public void setVolumes(Set<IVolumeSource> volumeSources) {
        ModelNode vol = this.get(VOLUMES);
        vol.clear();
        if (volumeSources != null) {
            volumeSources.forEach(v -> vol.add(ModelNode.fromJSONString((String)v.toJSONString())));
        }
    }

    @Override
    public void addVolume(IVolumeSource volumeSource) {
        ModelNode volList = this.get(VOLUMES);
        if (this.hasVolumeNamed(volList, volumeSource.getName())) {
            return;
        }
        volList.add(ModelNode.fromJSONString((String)volumeSource.toJSONString()));
    }

    @Override
    public <T extends IVolumeSource> T addVolume(String volumetype, String name) {
        ModelNode volList = this.get(VOLUMES);
        ModelNode node = volList.add();
        node.get(volumetype).set(new ModelNode());
        IVolumeSource source = VolumeSource.create(node);
        source.setName(name);
        return (T)source;
    }

    @Override
    public void setServiceAccountName(String serviceAccountName) {
        this.set(SERVICEACCOUNTNAME, serviceAccountName);
    }

    @Override
    public String getServiceAccountName() {
        return this.asString(SERVICEACCOUNTNAME);
    }
}

