/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidationResult;
import org.keycloak.validate.Validator;
import org.keycloak.validate.Validators;

public class ValidationContext {
    private final KeycloakSession session;
    private Set<ValidationError> errors;
    private final Map<String, Object> attributes;

    public ValidationContext() {
        this(null, null);
    }

    public ValidationContext(KeycloakSession session) {
        this(session, null);
    }

    protected ValidationContext(KeycloakSession session, Set<ValidationError> errors) {
        this.session = session;
        this.errors = errors;
        this.attributes = new HashMap<String, Object>();
    }

    public Validator validator(String validatorId) {
        return Validators.validator(this.session, validatorId);
    }

    public void addError(ValidationError error) {
        if (this.errors == null) {
            this.errors = new LinkedHashSet<ValidationError>();
        }
        this.errors.add(error);
    }

    public boolean isValid() {
        return this.errors == null || this.errors.isEmpty();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public Set<ValidationError> getErrors() {
        return this.errors != null ? this.errors : Collections.emptySet();
    }

    public ValidationResult toResult() {
        return new ValidationResult(this.getErrors());
    }

    public String toString() {
        return "ValidationContext{valid=" + this.isValid() + ", errors=" + this.errors + ", attributes=" + this.attributes + '}';
    }
}

