/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import twitter4j.HttpClient;
import twitter4j.HttpClientConfiguration;
import twitter4j.HttpParameter;
import twitter4j.HttpRequest;
import twitter4j.HttpResponse;
import twitter4j.HttpResponseEvent;
import twitter4j.HttpResponseListener;
import twitter4j.Logger;
import twitter4j.RequestMethod;
import twitter4j.TwitterException;
import twitter4j.Version;
import twitter4j.auth.Authorization;

public abstract class HttpClientBase
implements HttpClient,
Serializable {
    private static final Logger logger = Logger.getLogger(HttpClientBase.class);
    private static final long serialVersionUID = -8016974810651763053L;
    protected final HttpClientConfiguration CONF;
    private final Map<String, String> requestHeaders;

    public HttpClientBase(HttpClientConfiguration conf) {
        this.CONF = conf;
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("X-Twitter-Client-Version", Version.getVersion());
        this.requestHeaders.put("X-Twitter-Client-URL", "http://twitter4j.org/en/twitter4j-" + Version.getVersion() + ".xml");
        this.requestHeaders.put("X-Twitter-Client", "Twitter4J");
        this.requestHeaders.put("User-Agent", "twitter4j http://twitter4j.org/ /" + Version.getVersion());
        if (conf.isGZIPEnabled()) {
            this.requestHeaders.put("Accept-Encoding", "gzip");
        }
    }

    protected boolean isProxyConfigured() {
        return this.CONF.getHttpProxyHost() != null && !this.CONF.getHttpProxyHost().equals("");
    }

    public void write(DataOutputStream out, String outStr) throws IOException {
        out.writeBytes(outStr);
        logger.debug(outStr);
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public void addDefaultRequestHeader(String name, String value) {
        this.requestHeaders.put(name, value);
    }

    @Override
    public final HttpResponse request(HttpRequest req) throws TwitterException {
        return this.handleRequest(req);
    }

    @Override
    public final HttpResponse request(HttpRequest req, HttpResponseListener listener) throws TwitterException {
        try {
            HttpResponse res = this.handleRequest(req);
            if (listener != null) {
                listener.httpResponseReceived(new HttpResponseEvent(req, res, null));
            }
            return res;
        }
        catch (TwitterException te) {
            if (listener != null) {
                listener.httpResponseReceived(new HttpResponseEvent(req, null, te));
            }
            throw te;
        }
    }

    abstract HttpResponse handleRequest(HttpRequest var1) throws TwitterException;

    @Override
    public HttpResponse get(String url, HttpParameter[] parameters, Authorization authorization, HttpResponseListener listener) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.GET, url, parameters, authorization, this.requestHeaders), listener);
    }

    @Override
    public HttpResponse get(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.GET, url, null, null, this.requestHeaders));
    }

    @Override
    public HttpResponse post(String url, HttpParameter[] parameters, Authorization authorization, HttpResponseListener listener) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, parameters, authorization, this.requestHeaders), listener);
    }

    @Override
    public HttpResponse post(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, null, null, this.requestHeaders));
    }

    @Override
    public HttpResponse delete(String url, HttpParameter[] parameters, Authorization authorization, HttpResponseListener listener) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, parameters, authorization, this.requestHeaders), listener);
    }

    @Override
    public HttpResponse delete(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, null, null, this.requestHeaders));
    }

    @Override
    public HttpResponse head(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, null, null, this.requestHeaders));
    }

    @Override
    public HttpResponse put(String url, HttpParameter[] parameters, Authorization authorization, HttpResponseListener listener) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, parameters, authorization, this.requestHeaders), listener);
    }

    @Override
    public HttpResponse put(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, null, null, this.requestHeaders));
    }
}

