/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public interface CredentialInputUpdater {
    public boolean supportsCredentialType(String var1);

    public boolean updateCredential(RealmModel var1, UserModel var2, CredentialInput var3);

    public void disableCredentialType(RealmModel var1, UserModel var2, String var3);

    @Deprecated
    public Set<String> getDisableableCredentialTypes(RealmModel var1, UserModel var2);

    default public Stream<String> getDisableableCredentialTypesStream(RealmModel realm, UserModel user) {
        Set<String> result = this.getDisableableCredentialTypes(realm, user);
        return result != null ? result.stream() : Stream.empty();
    }

    public static interface Streams
    extends CredentialInputUpdater {
        @Override
        default public Set<String> getDisableableCredentialTypes(RealmModel realm, UserModel user) {
            return this.getDisableableCredentialTypesStream(realm, user).collect(Collectors.toSet());
        }

        @Override
        public Stream<String> getDisableableCredentialTypesStream(RealmModel var1, UserModel var2);
    }
}

