/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.account.freemarker.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrderedModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.storage.StorageId;

public class ApplicationsBean {
    private List<ApplicationEntry> applications = new LinkedList<ApplicationEntry>();

    public ApplicationsBean(KeycloakSession session, RealmModel realm, UserModel user) {
        Set<ClientModel> offlineClients = new UserSessionManager(session).findClientsWithOfflineToken(realm, user);
        this.applications = this.getApplications(session, realm, user).filter(client -> !ApplicationsBean.isAdminClient(client) || AdminPermissions.realms(session, realm, user).isAdmin()).map(client -> this.toApplicationEntry(session, realm, user, (ClientModel)client, offlineClients)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static boolean isAdminClient(ClientModel client) {
        return client.getClientId().equals("admin-cli") || client.getClientId().equals("security-admin-console");
    }

    private Stream<ClientModel> getApplications(KeycloakSession session, RealmModel realm, UserModel user) {
        Predicate<ClientModel> bearerOnly = ClientModel::isBearerOnly;
        Stream<ClientModel> clients = realm.getClientsStream().filter(bearerOnly.negate());
        Predicate<ClientModel> isLocal = client -> new StorageId(client.getId()).isLocal();
        return Stream.concat(clients, session.users().getConsentsStream(realm, user.getId()).map(UserConsentModel::getClient).filter(isLocal.negate())).distinct();
    }

    private void processRoles(Set<RoleModel> inputRoles, List<RoleModel> realmRoles, MultivaluedHashMap<String, ClientRoleEntry> clientRoles) {
        for (RoleModel role : inputRoles) {
            if (role.getContainer() instanceof RealmModel) {
                realmRoles.add(role);
                continue;
            }
            ClientModel currentClient = (ClientModel)role.getContainer();
            ClientRoleEntry clientRole = new ClientRoleEntry(currentClient.getClientId(), currentClient.getName(), role.getName(), role.getDescription());
            clientRoles.add((Object)currentClient.getClientId(), (Object)clientRole);
        }
    }

    public List<ApplicationEntry> getApplications() {
        return this.applications;
    }

    private ApplicationEntry toApplicationEntry(KeycloakSession session, RealmModel realm, UserModel user, ClientModel client, Set<ClientModel> offlineClients) {
        UserConsentModel consent;
        Stream<ClientScopeModel> allClientScopes = Stream.concat(client.getClientScopes(true).values().stream(), client.getClientScopes(false).values().stream());
        allClientScopes = Stream.concat(allClientScopes, Stream.of(client)).distinct();
        Set<RoleModel> availableRoles = TokenManager.getAccess(user, client, allClientScopes);
        if (!ApplicationsBean.isAdminClient(client) && availableRoles.isEmpty() && !client.isConsentRequired()) {
            return null;
        }
        LinkedList<RoleModel> realmRolesAvailable = new LinkedList<RoleModel>();
        MultivaluedHashMap resourceRolesAvailable = new MultivaluedHashMap();
        this.processRoles(availableRoles, realmRolesAvailable, (MultivaluedHashMap<String, ClientRoleEntry>)resourceRolesAvailable);
        LinkedList orderedScopes = new LinkedList();
        if (client.isConsentRequired() && (consent = session.users().getConsentByClient(realm, user.getId(), client.getId())) != null) {
            orderedScopes.addAll(consent.getGrantedClientScopes());
        }
        List<String> clientScopesGranted = orderedScopes.stream().sorted(OrderedModel.OrderedModelComparator.getInstance()).map(ClientScopeModel::getConsentScreenText).collect(Collectors.toList());
        ArrayList<String> additionalGrants = new ArrayList<String>();
        if (offlineClients.contains(client)) {
            additionalGrants.add("${offlineToken}");
        }
        return new ApplicationEntry(session, realmRolesAvailable, (MultivaluedHashMap<String, ClientRoleEntry>)resourceRolesAvailable, client, clientScopesGranted, additionalGrants);
    }

    public static class ClientRoleEntry {
        private final String clientId;
        private final String clientName;
        private final String roleName;
        private final String roleDescription;

        public ClientRoleEntry(String clientId, String clientName, String roleName, String roleDescription) {
            this.clientId = clientId;
            this.clientName = clientName;
            this.roleName = roleName;
            this.roleDescription = roleDescription;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientName() {
            return this.clientName;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public String getRoleDescription() {
            return this.roleDescription;
        }
    }

    public static class ApplicationEntry {
        private KeycloakSession session;
        private final List<RoleModel> realmRolesAvailable;
        private final MultivaluedHashMap<String, ClientRoleEntry> resourceRolesAvailable;
        private final ClientModel client;
        private final List<String> clientScopesGranted;
        private final List<String> additionalGrants;

        public ApplicationEntry(KeycloakSession session, List<RoleModel> realmRolesAvailable, MultivaluedHashMap<String, ClientRoleEntry> resourceRolesAvailable, ClientModel client, List<String> clientScopesGranted, List<String> additionalGrants) {
            this.session = session;
            this.realmRolesAvailable = realmRolesAvailable;
            this.resourceRolesAvailable = resourceRolesAvailable;
            this.client = client;
            this.clientScopesGranted = clientScopesGranted;
            this.additionalGrants = additionalGrants;
        }

        public List<RoleModel> getRealmRolesAvailable() {
            return this.realmRolesAvailable;
        }

        public MultivaluedHashMap<String, ClientRoleEntry> getResourceRolesAvailable() {
            return this.resourceRolesAvailable;
        }

        public List<String> getClientScopesGranted() {
            return this.clientScopesGranted;
        }

        public String getEffectiveUrl() {
            return ResolveRelative.resolveRelativeUri(this.session, this.getClient().getRootUrl(), this.getClient().getBaseUrl());
        }

        public ClientModel getClient() {
            return this.client;
        }

        public List<String> getAdditionalGrants() {
            return this.additionalGrants;
        }
    }
}

