/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints.request;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.keycloak.jose.JOSE;
import org.keycloak.jose.JOSEHeader;
import org.keycloak.jose.jwe.JWE;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointRequestParser;

public class AuthzEndpointRequestObjectParser
extends AuthzEndpointRequestParser {
    private final JsonNode requestParams;

    public AuthzEndpointRequestObjectParser(KeycloakSession session, String requestObject, ClientModel client) {
        this.requestParams = (JsonNode)session.tokens().decodeClientJWT(requestObject, client, this.createRequestObjectValidator(session), JsonNode.class);
        if (this.requestParams == null) {
            throw new RuntimeException("Failed to verify signature on 'request' object");
        }
        JsonNode clientId = this.requestParams.get("client_id");
        if (clientId == null) {
            throw new RuntimeException("Request object must be set with the client_id");
        }
        if (!client.getClientId().equals(clientId.asText())) {
            throw new RuntimeException("The client_id in the request object is not the same as the authorizing client");
        }
        if (this.requestParams.has("request_uri")) {
            throw new RuntimeException("The request_uri claim should not be set in the request object");
        }
        session.setAttribute("ParsedRequestObject", (Object)this.requestParams);
    }

    @Override
    protected String getParameter(String paramName) {
        JsonNode val = this.requestParams.get(paramName);
        if (val == null) {
            return null;
        }
        if (val.isValueNode()) {
            return val.asText();
        }
        return val.toString();
    }

    @Override
    protected Integer getIntParameter(String paramName) {
        JsonNode val = this.requestParams.get(paramName);
        return val == null ? null : Integer.valueOf(Integer.parseInt(this.getParameter(paramName)));
    }

    @Override
    protected Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        this.requestParams.fieldNames().forEachRemaining(keys::add);
        return keys;
    }

    private BiConsumer<JOSE, ClientModel> createRequestObjectValidator(KeycloakSession session) {
        return (jwt, clientModel) -> {
            if (jwt instanceof JWSInput) {
                JOSEHeader header = jwt.getHeader();
                String headerAlgorithm = header.getRawAlgorithm();
                if (headerAlgorithm == null) {
                    throw new RuntimeException("Request object signed algorithm not specified");
                }
                Algorithm requestedSignatureAlgorithm = OIDCAdvancedConfigWrapper.fromClientModel(clientModel).getRequestObjectSignatureAlg();
                if (requestedSignatureAlgorithm != null && !requestedSignatureAlgorithm.name().equals(headerAlgorithm)) {
                    throw new RuntimeException("Request object signed with different algorithm than client requested algorithm");
                }
            } else {
                JWE jwe;
                JWEHeader header;
                String encryptionAlg = OIDCAdvancedConfigWrapper.fromClientModel(clientModel).getRequestObjectEncryptionAlg();
                if (encryptionAlg != null && !encryptionAlg.equals(jwt.getHeader().getRawAlgorithm())) {
                    throw new RuntimeException("Request object encrypted with different algorithm than client requested algorithm");
                }
                String encryptionEncAlg = OIDCAdvancedConfigWrapper.fromClientModel(clientModel).getRequestObjectEncryptionEnc();
                if (encryptionEncAlg != null && !encryptionEncAlg.equals((header = (JWEHeader)(jwe = (JWE)jwt).getHeader()).getEncryptionAlgorithm())) {
                    throw new RuntimeException("Request object content encrypted with different algorithm than client requested algorithm");
                }
                session.setAttribute("EncryptedRequestObject", jwt);
            }
        };
    }

    @Override
    protected <T> T replaceIfNotNull(T previousVal, T newVal) {
        return newVal;
    }
}

