/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.saml.preprocessor.SamlAuthenticationPreprocessor;
import org.keycloak.services.managers.UserSessionCrossDCManager;

public class SamlSessionUtils {
    private static final String DELIMITER = "::";
    private static final Pattern PATTERN = Pattern.compile("::");

    public static String getSessionIndex(AuthenticatedClientSessionModel clientSession) {
        UserSessionModel userSession = clientSession.getUserSession();
        ClientModel client = clientSession.getClient();
        return userSession.getId() + DELIMITER + client.getId();
    }

    public static AuthenticatedClientSessionModel getClientSession(KeycloakSession session, RealmModel realm, String sessionIndex) {
        if (sessionIndex == null) {
            return null;
        }
        String[] parts = PATTERN.split(sessionIndex);
        if (parts.length != 2) {
            return null;
        }
        String userSessionId = parts[0];
        String clientUUID = parts[1];
        UserSessionModel userSession = new UserSessionCrossDCManager(session).getUserSessionWithClient(realm, userSessionId, false, clientUUID);
        if (userSession == null) {
            return null;
        }
        return userSession.getAuthenticatedClientSessionByClient(clientUUID);
    }

    public static Iterator<SamlAuthenticationPreprocessor> getSamlAuthenticationPreprocessorIterator(KeycloakSession session) {
        return session.getKeycloakSessionFactory().getProviderFactoriesStream(SamlAuthenticationPreprocessor.class).filter(Objects::nonNull).map(SamlAuthenticationPreprocessor.class::cast).iterator();
    }
}

