/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.enums.AccountRestApiVersion;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.representations.account.ClientRepresentation;
import org.keycloak.representations.account.ConsentRepresentation;
import org.keycloak.representations.account.ConsentScopeRepresentation;
import org.keycloak.representations.account.UserProfileAttributeMetadata;
import org.keycloak.representations.account.UserProfileMetadata;
import org.keycloak.representations.account.UserRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.UserConsentManager;
import org.keycloak.services.resources.account.AccountCredentialResource;
import org.keycloak.services.resources.account.LinkedAccountsResource;
import org.keycloak.services.resources.account.SessionResource;
import org.keycloak.services.resources.account.resources.ResourcesService;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.theme.Theme;
import org.keycloak.userprofile.AttributeChangeListener;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.EventAuditingAttributeChangeListener;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.ValidationException;
import org.keycloak.validate.Validators;

public class AccountRestService {
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    protected ClientConnection clientConnection;
    private final KeycloakSession session;
    private final ClientModel client;
    private final EventBuilder event;
    private EventStoreProvider eventStore;
    private Auth auth;
    private final RealmModel realm;
    private final UserModel user;
    private final Locale locale;
    private final AccountRestApiVersion version;

    public AccountRestService(KeycloakSession session, Auth auth, ClientModel client, EventBuilder event, AccountRestApiVersion version) {
        this.session = session;
        this.auth = auth;
        this.realm = auth.getRealm();
        this.user = auth.getUser();
        this.client = client;
        this.event = event;
        this.locale = session.getContext().resolveLocale(this.user);
        this.version = version;
    }

    public void init() {
        this.eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
    }

    @Path(value="/")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public UserRepresentation account(@PathParam(value="userProfileMetadata") Boolean userProfileMetadata) {
        this.auth.requireOneOf("manage-account", "view-profile");
        UserModel user = this.auth.getUser();
        UserRepresentation rep = new UserRepresentation();
        rep.setId(user.getId());
        rep.setUsername(user.getUsername());
        rep.setFirstName(user.getFirstName());
        rep.setLastName(user.getLastName());
        rep.setEmail(user.getEmail());
        rep.setEmailVerified(user.isEmailVerified());
        UserProfileProvider provider = (UserProfileProvider)this.session.getProvider(UserProfileProvider.class);
        UserProfile profile = provider.create(UserProfileContext.ACCOUNT, user);
        rep.setAttributes(profile.getAttributes().getReadable(false));
        if (userProfileMetadata == null || userProfileMetadata.booleanValue()) {
            rep.setUserProfileMetadata(this.createUserProfileMetadata(profile));
        }
        return rep;
    }

    private UserProfileMetadata createUserProfileMetadata(UserProfile profile) {
        Map am = profile.getAttributes().getReadable();
        if (am == null) {
            return null;
        }
        List attributes = am.keySet().stream().map(name -> profile.getAttributes().getMetadata(name)).filter(Objects::nonNull).sorted((a, b) -> Integer.compare(a.getGuiOrder(), b.getGuiOrder())).map(sam -> this.toRestMetadata((AttributeMetadata)sam, profile)).collect(Collectors.toList());
        return new UserProfileMetadata(attributes);
    }

    private UserProfileAttributeMetadata toRestMetadata(AttributeMetadata am, UserProfile profile) {
        return new UserProfileAttributeMetadata(am.getName(), am.getAttributeDisplayName(), profile.getAttributes().isRequired(am.getName()), profile.getAttributes().isReadOnly(am.getName()), am.getAnnotations(), this.toValidatorMetadata(am));
    }

    private Map<String, Map<String, Object>> toValidatorMetadata(AttributeMetadata am) {
        return am.getValidators() == null ? null : am.getValidators().stream().filter(avm -> Validators.validator((KeycloakSession)this.session, (String)avm.getValidatorId()) instanceof ConfiguredProvider).collect(Collectors.toMap(AttributeValidatorMetadata::getValidatorId, AttributeValidatorMetadata::getValidatorConfig));
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoCache
    public Response updateAccount(UserRepresentation rep) {
        this.auth.require("manage-account");
        this.event.event(EventType.UPDATE_PROFILE).client(this.auth.getClient()).user(this.auth.getUser()).detail("context", UserProfileContext.ACCOUNT.name());
        UserProfileProvider profileProvider = (UserProfileProvider)this.session.getProvider(UserProfileProvider.class);
        UserProfile profile = profileProvider.create(UserProfileContext.ACCOUNT, rep.toAttributes(), this.auth.getUser());
        try {
            profile.update(new AttributeChangeListener[]{new EventAuditingAttributeChangeListener(profile, this.event)});
            this.event.success();
            return Response.noContent().build();
        }
        catch (ValidationException pve) {
            ArrayList<ErrorRepresentation> errors = new ArrayList<ErrorRepresentation>();
            for (ValidationException.Error err : pve.getErrors()) {
                errors.add(new ErrorRepresentation(err.getAttribute(), err.getMessage(), (Object[])this.validationErrorParamsToString(err.getMessageParameters(), profile.getAttributes())));
            }
            return ErrorResponse.errors(errors, pve.getStatusCode(), false);
        }
        catch (ReadOnlyException e) {
            return ErrorResponse.error("readOnlyUserMessage", Response.Status.BAD_REQUEST);
        }
    }

    private String[] validationErrorParamsToString(Object[] messageParameters, Attributes userProfileAttributes) {
        if (messageParameters == null) {
            return null;
        }
        String[] ret = new String[messageParameters.length];
        int i = 0;
        for (Object p : messageParameters) {
            if (p != null) {
                if (i == 0) {
                    AttributeMetadata am = userProfileAttributes.getMetadata(p.toString());
                    if (am != null) {
                        ret[i++] = am.getAttributeDisplayName();
                        continue;
                    }
                    ret[i++] = p.toString();
                    continue;
                }
                ret[i++] = p.toString();
                continue;
            }
            ++i;
        }
        return ret;
    }

    @Path(value="/sessions")
    public SessionResource sessions() {
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "view-profile");
        return new SessionResource(this.session, this.auth, this.request);
    }

    @Path(value="/credentials")
    public AccountCredentialResource credentials() {
        AccountRestService.checkAccountApiEnabled();
        return new AccountCredentialResource(this.session, this.user, this.auth);
    }

    @Path(value="/resources")
    public ResourcesService resources() {
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "view-profile");
        return new ResourcesService(this.session, this.user, this.auth, this.request);
    }

    private ClientRepresentation modelToRepresentation(ClientModel model, List<String> inUseClients, List<String> offlineClients, Map<String, UserConsentModel> consents) {
        ClientRepresentation representation = new ClientRepresentation();
        representation.setClientId(model.getClientId());
        representation.setClientName(StringPropertyReplacer.replaceProperties((String)model.getName(), (Properties)this.getProperties()));
        representation.setDescription(model.getDescription());
        representation.setUserConsentRequired(model.isConsentRequired());
        representation.setInUse(inUseClients.contains(model.getClientId()));
        representation.setOfflineAccess(offlineClients.contains(model.getClientId()));
        representation.setRootUrl(model.getRootUrl());
        representation.setBaseUrl(model.getBaseUrl());
        representation.setEffectiveUrl(ResolveRelative.resolveRelativeUri(this.session, model.getRootUrl(), model.getBaseUrl()));
        UserConsentModel consentModel = consents.get(model.getClientId());
        if (consentModel != null) {
            representation.setConsent(this.modelToRepresentation(consentModel));
            representation.setLogoUri(model.getAttribute("logoUri"));
            representation.setPolicyUri(model.getAttribute("policyUri"));
            representation.setTosUri(model.getAttribute("tosUri"));
        }
        return representation;
    }

    private ConsentRepresentation modelToRepresentation(UserConsentModel model) {
        List grantedScopes = model.getGrantedClientScopes().stream().map(m -> new ConsentScopeRepresentation(m.getId(), m.getName(), StringPropertyReplacer.replaceProperties((String)m.getConsentScreenText(), (Properties)this.getProperties()))).collect(Collectors.toList());
        return new ConsentRepresentation(grantedScopes, model.getCreatedDate(), model.getLastUpdatedDate());
    }

    private Properties getProperties() {
        try {
            return this.session.theme().getTheme(Theme.Type.ACCOUNT).getMessages(this.locale);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Path(value="/applications/{clientId}/consent")
    @GET
    @Produces(value={"application/json"})
    public Response getConsent(@PathParam(value="clientId") String clientId) {
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "view-consent", "manage-consent");
        ClientModel client = this.realm.getClientByClientId(clientId);
        if (client == null) {
            return ErrorResponse.error("No client with clientId: " + clientId + " found.", Response.Status.NOT_FOUND);
        }
        UserConsentModel consent = this.session.users().getConsentByClient(this.realm, this.user.getId(), client.getId());
        if (consent == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)this.modelToRepresentation(consent)).build();
    }

    @Path(value="/applications/{clientId}/consent")
    @DELETE
    public Response revokeConsent(@PathParam(value="clientId") String clientId) {
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "manage-consent");
        this.event.event(EventType.REVOKE_GRANT);
        ClientModel client = this.realm.getClientByClientId(clientId);
        if (client == null) {
            this.event.event(EventType.REVOKE_GRANT_ERROR);
            String msg = String.format("No client with clientId: %s found.", clientId);
            this.event.error(msg);
            return ErrorResponse.error(msg, Response.Status.NOT_FOUND);
        }
        UserConsentManager.revokeConsentToClient(this.session, client, this.user);
        this.event.success();
        return Response.noContent().build();
    }

    @Path(value="/applications/{clientId}/consent")
    @POST
    @Produces(value={"application/json"})
    public Response grantConsent(@PathParam(value="clientId") String clientId, ConsentRepresentation consent) {
        return this.upsert(clientId, consent);
    }

    @Path(value="/applications/{clientId}/consent")
    @PUT
    @Produces(value={"application/json"})
    public Response updateConsent(@PathParam(value="clientId") String clientId, ConsentRepresentation consent) {
        return this.upsert(clientId, consent);
    }

    private Response upsert(String clientId, ConsentRepresentation consent) {
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "manage-consent");
        this.event.event(EventType.GRANT_CONSENT);
        ClientModel client = this.realm.getClientByClientId(clientId);
        if (client == null) {
            this.event.event(EventType.GRANT_CONSENT_ERROR);
            String msg = String.format("No client with clientId: %s found.", clientId);
            this.event.error(msg);
            return ErrorResponse.error(msg, Response.Status.NOT_FOUND);
        }
        try {
            UserConsentModel grantedConsent = this.createConsent(client, consent);
            if (this.session.users().getConsentByClient(this.realm, this.user.getId(), client.getId()) == null) {
                this.session.users().addConsent(this.realm, this.user.getId(), grantedConsent);
            } else {
                this.session.users().updateConsent(this.realm, this.user.getId(), grantedConsent);
            }
            this.event.success();
            grantedConsent = this.session.users().getConsentByClient(this.realm, this.user.getId(), client.getId());
            return Response.ok((Object)this.modelToRepresentation(grantedConsent)).build();
        }
        catch (IllegalArgumentException e) {
            return ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    private UserConsentModel createConsent(ClientModel client, ConsentRepresentation requested) throws IllegalArgumentException {
        UserConsentModel consent = new UserConsentModel(client);
        Map availableGrants = this.realm.getClientScopesStream().collect(Collectors.toMap(ClientScopeModel::getId, Function.identity()));
        if (client.isConsentRequired()) {
            availableGrants.put(client.getId(), client);
        }
        for (ConsentScopeRepresentation scopeRepresentation : requested.getGrantedScopes()) {
            ClientScopeModel scopeModel = (ClientScopeModel)availableGrants.get(scopeRepresentation.getId());
            if (scopeModel == null) {
                String msg = String.format("Scope id %s does not exist for client %s.", scopeRepresentation, consent.getClient().getName());
                this.event.error(msg);
                throw new IllegalArgumentException(msg);
            }
            consent.addGrantedClientScope(scopeModel);
        }
        return consent;
    }

    @Path(value="/linked-accounts")
    public LinkedAccountsResource linkedAccounts() {
        return new LinkedAccountsResource(this.session, this.request, this.client, this.auth, this.event, this.user);
    }

    @Path(value="/applications")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<ClientRepresentation> applications(@QueryParam(value="name") String name) {
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "view-applications");
        HashSet clients = new HashSet();
        LinkedList inUseClients = new LinkedList();
        clients.addAll(this.session.sessions().getUserSessionsStream(this.realm, this.user).flatMap(s -> s.getAuthenticatedClientSessions().values().stream()).map(CommonClientSessionModel::getClient).peek(client -> inUseClients.add(client.getClientId())).collect(Collectors.toSet()));
        LinkedList offlineClients = new LinkedList();
        clients.addAll(this.session.sessions().getOfflineUserSessionsStream(this.realm, this.user).flatMap(s -> s.getAuthenticatedClientSessions().values().stream()).map(CommonClientSessionModel::getClient).peek(client -> offlineClients.add(client.getClientId())).collect(Collectors.toSet()));
        HashMap consentModels = new HashMap();
        clients.addAll(this.session.users().getConsentsStream(this.realm, this.user.getId()).peek(consent -> consentModels.put(consent.getClient().getClientId(), consent)).map(UserConsentModel::getClient).collect(Collectors.toSet()));
        this.realm.getAlwaysDisplayInConsoleClientsStream().forEach(clients::add);
        return clients.stream().filter(client -> !client.isBearerOnly() && !client.getClientId().isEmpty()).filter(client -> this.matches((ClientModel)client, name)).map(client -> this.modelToRepresentation((ClientModel)client, inUseClients, offlineClients, consentModels));
    }

    private boolean matches(ClientModel client, String name) {
        if (name == null) {
            return true;
        }
        if (client.getName() == null) {
            return false;
        }
        return client.getName().toLowerCase().contains(name.toLowerCase());
    }

    private static void checkAccountApiEnabled() {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ACCOUNT_API)) {
            throw new NotFoundException();
        }
    }
}

