/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ProviderEventManager;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;
import org.keycloak.services.resources.admin.permissions.RealmsPermissionEvaluator;

public class AdminPermissions {
    public static AdminPermissionEvaluator evaluator(KeycloakSession session, RealmModel realm, AdminAuth auth) {
        return new MgmtPermissions(session, realm, auth);
    }

    public static AdminPermissionEvaluator evaluator(KeycloakSession session, RealmModel realm, RealmModel adminsRealm, UserModel admin) {
        return new MgmtPermissions(session, realm, adminsRealm, admin);
    }

    public static RealmsPermissionEvaluator realms(KeycloakSession session, AdminAuth auth) {
        return new MgmtPermissions(session, auth);
    }

    public static RealmsPermissionEvaluator realms(KeycloakSession session, RealmModel adminsRealm, UserModel admin) {
        return new MgmtPermissions(session, adminsRealm, admin);
    }

    public static AdminPermissionManagement management(KeycloakSession session, RealmModel realm) {
        return new MgmtPermissions(session, realm);
    }

    public static void registerListener(ProviderEventManager manager) {
        manager.register(new ProviderEventListener(){

            public void onEvent(ProviderEvent event) {
                if (event instanceof RoleContainerModel.RoleRemovedEvent) {
                    RoleContainerModel.RoleRemovedEvent cast = (RoleContainerModel.RoleRemovedEvent)event;
                    RoleModel role = cast.getRole();
                    RealmModel realm = role.getContainer() instanceof ClientModel ? ((ClientModel)role.getContainer()).getRealm() : (RealmModel)role.getContainer();
                    AdminPermissions.management(cast.getKeycloakSession(), realm).roles().setPermissionsEnabled(role, false);
                } else if (event instanceof ClientModel.ClientRemovedEvent) {
                    ClientModel.ClientRemovedEvent cast = (ClientModel.ClientRemovedEvent)event;
                    AdminPermissions.management(cast.getKeycloakSession(), cast.getClient().getRealm()).clients().setPermissionsEnabled(cast.getClient(), false);
                } else if (event instanceof GroupModel.GroupRemovedEvent) {
                    GroupModel.GroupRemovedEvent cast = (GroupModel.GroupRemovedEvent)event;
                    AdminPermissions.management(cast.getKeycloakSession(), cast.getRealm()).groups().setPermissionsEnabled(cast.getGroup(), false);
                }
            }
        });
    }
}

