/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.theme.FolderTheme;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;

public class FolderThemeProvider
implements ThemeProvider {
    private File themesDir;

    public FolderThemeProvider(File themesDir) {
        this.themesDir = themesDir;
    }

    public int getProviderPriority() {
        return 100;
    }

    public Theme getTheme(String name, Theme.Type type) throws IOException {
        if (this.themesDir == null) {
            return null;
        }
        File themeDir = this.getThemeDir(name, type);
        return themeDir.isDirectory() ? new FolderTheme(themeDir, name, type) : null;
    }

    public Set<String> nameSet(Theme.Type type) {
        if (this.themesDir == null) {
            return Collections.emptySet();
        }
        final String typeName = type.name().toLowerCase();
        File[] themeDirs = this.themesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && new File(pathname, typeName).isDirectory();
            }
        });
        if (themeDirs != null) {
            HashSet<String> names = new HashSet<String>();
            for (File themeDir : themeDirs) {
                names.add(themeDir.getName());
            }
            return names;
        }
        return Collections.emptySet();
    }

    public boolean hasTheme(String name, Theme.Type type) {
        return this.themesDir != null ? this.getThemeDir(name, type).isDirectory() : false;
    }

    public void close() {
    }

    private File getThemeDir(String name, Theme.Type type) {
        File f = new File(this.themesDir, name + File.separator + type.name().toLowerCase());
        try {
            if (!f.getCanonicalPath().startsWith(this.themesDir.getCanonicalPath() + File.separator)) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        return f;
    }
}

