/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.HTMLOutputFormat;
import freemarker.core.OutputFormat;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.Config;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.KeycloakSanitizerMethod;
import org.keycloak.theme.Theme;

public class FreeMarkerUtil {
    private ConcurrentHashMap<String, Template> cache;
    private final KeycloakSanitizerMethod kcSanitizeMethod = new KeycloakSanitizerMethod();

    public FreeMarkerUtil() {
        if (Config.scope((String[])new String[]{"theme"}).getBoolean("cacheTemplates", Boolean.valueOf(true)).booleanValue()) {
            this.cache = new ConcurrentHashMap();
        }
    }

    public String processTemplate(Object data, String templateName, Theme theme) throws FreeMarkerException {
        if (data instanceof Map) {
            ((Map)data).put("kcSanitize", this.kcSanitizeMethod);
        }
        try {
            Template template;
            if (this.cache != null) {
                String key = theme.getName() + "/" + templateName;
                template = this.cache.get(key);
                if (template == null && this.cache.putIfAbsent(key, template = this.getTemplate(templateName, theme)) != null) {
                    template = this.cache.get(key);
                }
            } else {
                template = this.getTemplate(templateName, theme);
            }
            StringWriter out = new StringWriter();
            template.process(data, (Writer)out);
            return ((Object)out).toString();
        }
        catch (Exception e) {
            throw new FreeMarkerException("Failed to process template " + templateName, e);
        }
    }

    private Template getTemplate(String templateName, Theme theme) throws IOException {
        Configuration cfg = new Configuration();
        if (templateName.toLowerCase().endsWith(".ftl")) {
            cfg.setOutputFormat((OutputFormat)HTMLOutputFormat.INSTANCE);
        }
        cfg.setTemplateLoader((TemplateLoader)new ThemeTemplateLoader(theme));
        return cfg.getTemplate(templateName, "UTF-8");
    }

    static class ThemeTemplateLoader
    extends URLTemplateLoader {
        private Theme theme;

        public ThemeTemplateLoader(Theme theme) {
            this.theme = theme;
        }

        protected URL getURL(String name) {
            try {
                return this.theme.getTemplate(name);
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

