/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging.core;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogLevel;
import liquibase.logging.Logger;

public abstract class AbstractLogger
implements Logger {
    private LogLevel logLevel;
    private DatabaseChangeLog databaseChangeLog;
    private ChangeSet changeSet;

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(String logLevel) {
        this.setLogLevel(this.toLogLevel(logLevel));
    }

    @Override
    public void closeLogFile() {
    }

    protected LogLevel toLogLevel(String logLevel) {
        if ("debug".equalsIgnoreCase(logLevel)) {
            return LogLevel.DEBUG;
        }
        if ("info".equalsIgnoreCase(logLevel)) {
            return LogLevel.INFO;
        }
        if ("warning".equalsIgnoreCase(logLevel)) {
            return LogLevel.WARNING;
        }
        if ("severe".equalsIgnoreCase(logLevel)) {
            return LogLevel.SEVERE;
        }
        if ("off".equalsIgnoreCase(logLevel)) {
            return LogLevel.OFF;
        }
        throw new UnexpectedLiquibaseException("Unknown log level: " + logLevel + ".  Valid levels are: debug, info, warning, severe, off");
    }

    protected String buildMessage(String message) {
        StringBuilder msg = new StringBuilder();
        if (this.databaseChangeLog != null) {
            msg.append(this.databaseChangeLog.getFilePath()).append(": ");
        }
        if (this.changeSet != null) {
            String changeSetName = this.changeSet.toString(false);
            msg.append(changeSetName.replace(changeSetName + "::", "")).append(": ");
        }
        msg.append(message);
        return msg.toString();
    }

    @Override
    public void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }

    @Override
    public void setChangeLog(DatabaseChangeLog databaseChangeLog) {
        this.databaseChangeLog = databaseChangeLog;
    }

    @Override
    public void setChangeSet(ChangeSet changeSet) {
        this.changeSet = changeSet;
    }
}

