/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.ArrayFrob;
import org.freedesktop.dbus.Container;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMap;
import org.freedesktop.dbus.DBusSerializable;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.Position;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.DBusStructType;

public class Marshalling {
    private static Map<Type, String[]> typeCache = new HashMap<Type, String[]>();
    private static StringBuffer[] out = new StringBuffer[10];

    public static String getDBusType(Type[] c) throws DBusException {
        StringBuffer sb = new StringBuffer();
        for (Type t : c) {
            for (String s : Marshalling.getDBusType(t)) {
                sb.append(s);
            }
        }
        return sb.toString();
    }

    public static String[] getDBusType(Type c) throws DBusException {
        String[] cached = typeCache.get(c);
        if (null != cached) {
            return cached;
        }
        cached = Marshalling.getDBusType(c, false);
        typeCache.put(c, cached);
        return cached;
    }

    public static String[] getDBusType(Type c, boolean basic) throws DBusException {
        return Marshalling.recursiveGetDBusType(c, basic, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] recursiveGetDBusType(Type c, boolean basic, int level) throws DBusException {
        Type[] ts;
        block67: {
            int n;
            Field[] fieldArray;
            block68: {
                int s4;
                int t3;
                Type[] typeArray;
                Vector<String> vs;
                block66: {
                    int AIOOBe2;
                    Type[] t22;
                    block65: {
                        Type[] newtypes;
                        block62: {
                            String[] s2;
                            block63: {
                                ParameterizedType p;
                                block64: {
                                    block61: {
                                        if (out.length <= level) {
                                            StringBuffer[] newout = new StringBuffer[out.length];
                                            System.arraycopy(out, 0, newout, 0, out.length);
                                            out = newout;
                                        }
                                        if (null == out[level]) {
                                            Marshalling.out[level] = new StringBuffer();
                                        } else {
                                            out[level].delete(0, out[level].length());
                                        }
                                        if (basic && !(c instanceof Class)) {
                                            throw new DBusException(c + Gettext.getString("notBasicType"));
                                        }
                                        if (c instanceof TypeVariable) {
                                            out[level].append('v');
                                            return new String[]{out[level].toString()};
                                        }
                                        if (c instanceof GenericArrayType) {
                                            out[level].append('a');
                                            s2 = Marshalling.recursiveGetDBusType(((GenericArrayType)c).getGenericComponentType(), false, level + 1);
                                            if (s2.length != 1) {
                                                throw new DBusException(Gettext.getString("multiValuedArrayNotPermitted"));
                                            }
                                            out[level].append(s2[0]);
                                            return new String[]{out[level].toString()};
                                        }
                                        if ((!(c instanceof Class) || !DBusSerializable.class.isAssignableFrom((Class)c)) && (!(c instanceof ParameterizedType) || !DBusSerializable.class.isAssignableFrom((Class)((ParameterizedType)c).getRawType()))) break block61;
                                        newtypes = null;
                                        if (c instanceof Class) {
                                            for (Method m : ((Class)c).getDeclaredMethods()) {
                                                if (!m.getName().equals("deserialize")) continue;
                                                newtypes = m.getGenericParameterTypes();
                                            }
                                        } else {
                                            for (Method m : ((Class)((ParameterizedType)c).getRawType()).getDeclaredMethods()) {
                                                if (!m.getName().equals("deserialize")) continue;
                                                newtypes = m.getGenericParameterTypes();
                                            }
                                        }
                                        if (null == newtypes) {
                                            throw new DBusException(Gettext.getString("mustImplementDeserializeMethod"));
                                        }
                                        break block62;
                                    }
                                    if (!(c instanceof ParameterizedType)) break block63;
                                    p = (ParameterizedType)c;
                                    if (p.getRawType().equals(Map.class)) {
                                        out[level].append("a{");
                                        Type[] t22 = p.getActualTypeArguments();
                                        try {
                                            String[] s3 = Marshalling.recursiveGetDBusType(t22[0], true, level + 1);
                                            if (s3.length != 1) {
                                                throw new DBusException(Gettext.getString("multiValuedArrayNotPermitted"));
                                            }
                                            out[level].append(s3[0]);
                                            s3 = Marshalling.recursiveGetDBusType(t22[1], false, level + 1);
                                            if (s3.length != 1) {
                                                throw new DBusException(Gettext.getString("multiValuedArrayNotPermitted"));
                                            }
                                            out[level].append(s3[0]);
                                        }
                                        catch (ArrayIndexOutOfBoundsException AIOOBe2) {
                                            if (!AbstractConnection.EXCEPTION_DEBUG) throw new DBusException(Gettext.getString("mapParameters"));
                                            // empty if block
                                            throw new DBusException(Gettext.getString("mapParameters"));
                                        }
                                        out[level].append('}');
                                        return new String[]{out[level].toString()};
                                    }
                                    if (!List.class.isAssignableFrom((Class)p.getRawType())) break block64;
                                    t22 = p.getActualTypeArguments();
                                    AIOOBe2 = t22.length;
                                    break block65;
                                }
                                if (p.getRawType().equals(Variant.class)) {
                                    out[level].append('v');
                                    return new String[]{out[level].toString()};
                                }
                                if (DBusInterface.class.isAssignableFrom((Class)p.getRawType())) {
                                    out[level].append('o');
                                    return new String[]{out[level].toString()};
                                }
                                if (!Tuple.class.isAssignableFrom((Class)p.getRawType())) {
                                    throw new DBusException(Gettext.getString("nonExportableParameterizedType") + c);
                                }
                                Type[] ts2 = p.getActualTypeArguments();
                                vs = new Vector<String>();
                                typeArray = ts2;
                                t3 = typeArray.length;
                                s4 = 0;
                                break block66;
                            }
                            if (c.equals(Byte.class)) {
                                out[level].append('y');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Byte.TYPE)) {
                                out[level].append('y');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Boolean.class)) {
                                out[level].append('b');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Boolean.TYPE)) {
                                out[level].append('b');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Short.class)) {
                                out[level].append('n');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Short.TYPE)) {
                                out[level].append('n');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(UInt16.class)) {
                                out[level].append('q');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Integer.class)) {
                                out[level].append('i');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Integer.TYPE)) {
                                out[level].append('i');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(UInt32.class)) {
                                out[level].append('u');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Long.class)) {
                                out[level].append('x');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Long.TYPE)) {
                                out[level].append('x');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(UInt64.class)) {
                                out[level].append('t');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Double.class)) {
                                out[level].append('d');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Double.TYPE)) {
                                out[level].append('d');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Float.class) && AbstractConnection.FLOAT_SUPPORT) {
                                out[level].append('f');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Float.class)) {
                                out[level].append('d');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Float.TYPE) && AbstractConnection.FLOAT_SUPPORT) {
                                out[level].append('f');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Float.TYPE)) {
                                out[level].append('d');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(String.class)) {
                                out[level].append('s');
                                return new String[]{out[level].toString()};
                            }
                            if (c.equals(Variant.class)) {
                                out[level].append('v');
                                return new String[]{out[level].toString()};
                            }
                            if (c instanceof Class && DBusInterface.class.isAssignableFrom((Class)c)) {
                                out[level].append('o');
                                return new String[]{out[level].toString()};
                            }
                            if (c instanceof Class && Path.class.equals((Object)((Class)c))) {
                                out[level].append('o');
                                return new String[]{out[level].toString()};
                            }
                            if (c instanceof Class && ObjectPath.class.equals((Object)((Class)c))) {
                                out[level].append('o');
                                return new String[]{out[level].toString()};
                            }
                            if (c instanceof Class && ((Class)c).isArray()) {
                                if (Type.class.equals(((Class)c).getComponentType())) {
                                    out[level].append('g');
                                    return new String[]{out[level].toString()};
                                } else {
                                    out[level].append('a');
                                    s2 = Marshalling.recursiveGetDBusType(((Class)c).getComponentType(), false, level + 1);
                                    if (s2.length != 1) {
                                        throw new DBusException(Gettext.getString("multiValuedArrayNotPermitted"));
                                    }
                                    out[level].append(s2[0]);
                                }
                                return new String[]{out[level].toString()};
                            }
                            if (!(c instanceof Class) || !Struct.class.isAssignableFrom((Class)c)) throw new DBusException(Gettext.getString("nonExportableType") + c);
                            out[level].append('(');
                            ts = Container.getTypeCache(c);
                            if (null != ts) break block67;
                            Field[] fs = ((Class)c).getDeclaredFields();
                            ts = new Type[fs.length];
                            fieldArray = fs;
                            n = fieldArray.length;
                            break block68;
                        }
                        String[] sigs = new String[newtypes.length];
                        int j = 0;
                        while (true) {
                            if (j >= sigs.length) {
                                return sigs;
                            }
                            String[] ss = Marshalling.recursiveGetDBusType(newtypes[j], false, level + 1);
                            if (1 != ss.length) {
                                throw new DBusException(Gettext.getString("mustSerializeNativeDBusTypes"));
                            }
                            sigs[j] = ss[0];
                            ++j;
                        }
                    }
                    for (int i = 0; i < AIOOBe2; ++i) {
                        Type t3 = t22[i];
                        if (Type.class.equals((Object)t3)) {
                            out[level].append('g');
                            continue;
                        }
                        String[] s4 = Marshalling.recursiveGetDBusType(t3, false, level + 1);
                        if (s4.length != 1) {
                            throw new DBusException(Gettext.getString("multiValuedArrayNotPermitted"));
                        }
                        out[level].append('a');
                        out[level].append(s4[0]);
                    }
                    return new String[]{out[level].toString()};
                }
                while (true) {
                    if (s4 >= t3) {
                        return vs.toArray(new String[0]);
                    }
                    Type t4 = typeArray[s4];
                    for (String s5 : Marshalling.recursiveGetDBusType(t4, false, level + 1)) {
                        vs.add(s5);
                    }
                    ++s4;
                }
            }
            for (int t3 = 0; t3 < n; ++t3) {
                Field f = fieldArray[t3];
                Position p = f.getAnnotation(Position.class);
                if (null == p) continue;
                ts[p.value()] = f.getGenericType();
            }
            Container.putTypeCache(c, ts);
        }
        for (Type t : ts) {
            if (t == null) continue;
            for (String s : Marshalling.recursiveGetDBusType(t, false, level + 1)) {
                out[level].append(s);
            }
        }
        out[level].append(')');
        return new String[]{out[level].toString()};
    }

    public static int getJavaType(String dbus, List<Type> rv, int limit) throws DBusException {
        if (null == dbus || "".equals(dbus) || 0 == limit) {
            return 0;
        }
        try {
            int i;
            block21: for (i = 0; i < dbus.length() && (-1 == limit || limit > rv.size()); ++i) {
                switch (dbus.charAt(i)) {
                    case '(': {
                        int j = i + 1;
                        int c = 1;
                        while (c > 0) {
                            if (')' == dbus.charAt(j)) {
                                --c;
                            } else if ('(' == dbus.charAt(j)) {
                                ++c;
                            }
                            ++j;
                        }
                        Vector<Type> contained = new Vector();
                        int c2 = Marshalling.getJavaType(dbus.substring(i + 1, j - 1), contained, -1);
                        rv.add(new DBusStructType(contained.toArray(new Type[0])));
                        i = j;
                        continue block21;
                    }
                    case 'a': {
                        int c2;
                        Vector<Type> contained;
                        if ('{' == dbus.charAt(i + 1)) {
                            contained = new Vector();
                            c2 = Marshalling.getJavaType(dbus.substring(i + 2), contained, 2);
                            rv.add(new DBusMapType(contained.get(0), contained.get(1)));
                            i += c2 + 2;
                            continue block21;
                        }
                        contained = new Vector();
                        c2 = Marshalling.getJavaType(dbus.substring(i + 1), contained, 1);
                        rv.add(new DBusListType(contained.get(0)));
                        i += c2;
                        continue block21;
                    }
                    case 'v': {
                        rv.add((Type)((Object)Variant.class));
                        continue block21;
                    }
                    case 'b': {
                        rv.add((Type)((Object)Boolean.class));
                        continue block21;
                    }
                    case 'n': {
                        rv.add((Type)((Object)Short.class));
                        continue block21;
                    }
                    case 'y': {
                        rv.add((Type)((Object)Byte.class));
                        continue block21;
                    }
                    case 'o': {
                        rv.add((Type)((Object)DBusInterface.class));
                        continue block21;
                    }
                    case 'q': {
                        rv.add((Type)((Object)UInt16.class));
                        continue block21;
                    }
                    case 'i': {
                        rv.add((Type)((Object)Integer.class));
                        continue block21;
                    }
                    case 'u': {
                        rv.add((Type)((Object)UInt32.class));
                        continue block21;
                    }
                    case 'x': {
                        rv.add((Type)((Object)Long.class));
                        continue block21;
                    }
                    case 't': {
                        rv.add((Type)((Object)UInt64.class));
                        continue block21;
                    }
                    case 'd': {
                        rv.add((Type)((Object)Double.class));
                        continue block21;
                    }
                    case 'f': {
                        rv.add((Type)((Object)Float.class));
                        continue block21;
                    }
                    case 's': {
                        rv.add((Type)((Object)String.class));
                        continue block21;
                    }
                    case 'g': {
                        rv.add((Type)((Object)Type[].class));
                        continue block21;
                    }
                    case '{': {
                        rv.add((Type)((Object)Map.Entry.class));
                        Vector<Type> contained = new Vector<Type>();
                        int c2 = Marshalling.getJavaType(dbus.substring(i + 1), contained, 2);
                        i += c2 + 1;
                        continue block21;
                    }
                    default: {
                        throw new DBusException(MessageFormat.format(Gettext.getString("parseDBusSignatureFailure"), dbus, Character.valueOf(dbus.charAt(i))));
                    }
                }
            }
            return i;
        }
        catch (IndexOutOfBoundsException IOOBe) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(Gettext.getString("parseDBusTypeSignatureFailure") + dbus);
        }
    }

    public static Object[] convertParameters(Object[] parameters, Type[] types, AbstractConnection conn) throws DBusException {
        if (null == parameters) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (null == parameters[i]) continue;
            if (parameters[i] instanceof DBusSerializable) {
                for (Method m : parameters[i].getClass().getDeclaredMethods()) {
                    if (!m.getName().equals("deserialize")) continue;
                    Class<?>[] newtypes = m.getParameterTypes();
                    Type[] expand = new Type[types.length + newtypes.length - 1];
                    System.arraycopy(types, 0, expand, 0, i);
                    System.arraycopy(newtypes, 0, expand, i, newtypes.length);
                    System.arraycopy(types, i + 1, expand, i + newtypes.length, types.length - i - 1);
                    types = expand;
                    Object[] newparams = ((DBusSerializable)parameters[i]).serialize();
                    Object[] exparams = new Object[parameters.length + newparams.length - 1];
                    System.arraycopy(parameters, 0, exparams, 0, i);
                    System.arraycopy(newparams, 0, exparams, i, newparams.length);
                    System.arraycopy(parameters, i + 1, exparams, i + newparams.length, parameters.length - i - 1);
                    parameters = exparams;
                }
                --i;
                continue;
            }
            if (parameters[i] instanceof Tuple) {
                Type[] newtypes = ((ParameterizedType)types[i]).getActualTypeArguments();
                Type[] expand = new Type[types.length + newtypes.length - 1];
                System.arraycopy(types, 0, expand, 0, i);
                System.arraycopy(newtypes, 0, expand, i, newtypes.length);
                System.arraycopy(types, i + 1, expand, i + newtypes.length, types.length - i - 1);
                types = expand;
                Object[] newparams = ((Tuple)parameters[i]).getParameters();
                Object[] exparams = new Object[parameters.length + newparams.length - 1];
                System.arraycopy(parameters, 0, exparams, 0, i);
                System.arraycopy(newparams, 0, exparams, i, newparams.length);
                System.arraycopy(parameters, i + 1, exparams, i + newparams.length, parameters.length - i - 1);
                parameters = exparams;
                --i;
                continue;
            }
            if (types[i] instanceof TypeVariable && !(parameters[i] instanceof Variant)) {
                parameters[i] = new Variant<Object>(parameters[i]);
                continue;
            }
            if (!(parameters[i] instanceof DBusInterface)) continue;
            parameters[i] = conn.getExportedObject((DBusInterface)parameters[i]);
        }
        return parameters;
    }

    /*
     * WARNING - void declaration
     */
    static Object deSerializeParameter(Object parameter, Type type, AbstractConnection conn) throws Exception {
        Type type2;
        Object[] ts;
        if (null == parameter) {
            return null;
        }
        if (type instanceof TypeVariable && parameter instanceof Variant) {
            parameter = ((Variant)parameter).getValue();
        }
        if (type instanceof Class && ((Class)type).isArray() && ((Class)type).getComponentType().equals(Type.class) && parameter instanceof String) {
            Vector<Type> rv = new Vector<Type>();
            Marshalling.getJavaType((String)parameter, rv, -1);
            parameter = rv.toArray(new Type[0]);
        }
        if (parameter instanceof ObjectPath) {
            parameter = type instanceof Class && DBusInterface.class.isAssignableFrom((Class)type) ? conn.getExportedObject(((ObjectPath)parameter).source, ((ObjectPath)parameter).path) : new Path(((ObjectPath)parameter).path);
        }
        if (parameter instanceof Object[] && type instanceof Class && Struct.class.isAssignableFrom((Class)type)) {
            ts = Container.getTypeCache(type);
            if (null == ts) {
                void var7_12;
                AccessibleObject[] fs = ((Class)type).getDeclaredFields();
                ts = new Type[fs.length];
                Field[] fieldArray = fs;
                int n = fieldArray.length;
                boolean i = false;
                while (var7_12 < n) {
                    Field f = fieldArray[var7_12];
                    Position p = f.getAnnotation(Position.class);
                    if (null != p) {
                        ts[p.value()] = f.getGenericType();
                    }
                    ++var7_12;
                }
                Container.putTypeCache(type, (Type[])ts);
            }
            parameter = Marshalling.deSerializeParameters(parameter, (Type[])ts, conn);
            for (AccessibleObject accessibleObject : ((Class)type).getDeclaredConstructors()) {
                try {
                    parameter = ((Constructor)accessibleObject).newInstance(parameter);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        if (parameter instanceof Object[]) {
            ts = new Type[((Object[])parameter).length];
            Arrays.fill(ts, parameter.getClass().getComponentType());
            parameter = Marshalling.deSerializeParameters(parameter, (Type[])ts, conn);
        }
        if (parameter instanceof List && null != (type2 = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : (type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : (type instanceof Class && ((Class)type).isArray() ? ((Class)type).getComponentType() : null)))) {
            parameter = Marshalling.deSerializeParameters((List)parameter, type2, conn);
        }
        if ((type.equals(Float.class) || type.equals(Float.TYPE)) && !(parameter instanceof Float)) {
            parameter = Float.valueOf(((Number)parameter).floatValue());
        }
        if (parameter instanceof Object[] || parameter instanceof List || parameter.getClass().isArray()) {
            if (type instanceof ParameterizedType) {
                parameter = ArrayFrob.convert(parameter, (Class)((ParameterizedType)type).getRawType());
            } else if (type instanceof GenericArrayType) {
                Type ct = ((GenericArrayType)type).getGenericComponentType();
                Class cc = null;
                if (ct instanceof Class) {
                    cc = (Class)ct;
                }
                if (ct instanceof ParameterizedType) {
                    cc = (Class)((ParameterizedType)ct).getRawType();
                }
                Object o = Array.newInstance(cc, 0);
                parameter = ArrayFrob.convert(parameter, o.getClass());
            } else if (type instanceof Class && ((Class)type).isArray()) {
                Class<?> cc = ((Class)type).getComponentType();
                if ((cc.equals(Float.class) || cc.equals(Float.TYPE)) && parameter instanceof double[]) {
                    double[] tmp1 = (double[])parameter;
                    float[] tmp2 = new float[tmp1.length];
                    for (int i = 0; i < tmp1.length; ++i) {
                        tmp2[i] = (float)tmp1[i];
                    }
                    parameter = tmp2;
                }
                Object o = Array.newInstance(cc, 0);
                parameter = ArrayFrob.convert(parameter, o.getClass());
            }
        }
        if (parameter instanceof DBusMap) {
            DBusMap dmap = (DBusMap)parameter;
            Type[] maptypes = ((ParameterizedType)type).getActualTypeArguments();
            for (int i = 0; i < dmap.entries.length; ++i) {
                dmap.entries[i][0] = Marshalling.deSerializeParameter(dmap.entries[i][0], maptypes[0], conn);
                dmap.entries[i][1] = Marshalling.deSerializeParameter(dmap.entries[i][1], maptypes[1], conn);
            }
        }
        return parameter;
    }

    static List<Object> deSerializeParameters(List<Object> parameters, Type type, AbstractConnection conn) throws Exception {
        if (null == parameters) {
            return null;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            if (null == parameters.get(i)) continue;
            parameters.set(i, Marshalling.deSerializeParameter(parameters.get(i), type, conn));
        }
        return parameters;
    }

    static Object[] deSerializeParameters(Object[] parameters, Type[] types, AbstractConnection conn) throws Exception {
        if (null == parameters) {
            return null;
        }
        if (types.length == 1 && types[0] instanceof ParameterizedType && Tuple.class.isAssignableFrom((Class)((ParameterizedType)types[0]).getRawType())) {
            types = ((ParameterizedType)types[0]).getActualTypeArguments();
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (i >= types.length) {
                throw new DBusException(Gettext.getString("errorDeserializingMessage"));
            }
            if (null == parameters[i]) continue;
            if (types[i] instanceof Class && DBusSerializable.class.isAssignableFrom((Class)types[i]) || types[i] instanceof ParameterizedType && DBusSerializable.class.isAssignableFrom((Class)((ParameterizedType)types[i]).getRawType())) {
                Class dsc = types[i] instanceof Class ? (Class)types[i] : (Class)((ParameterizedType)types[i]).getRawType();
                for (Method m : dsc.getDeclaredMethods()) {
                    if (!m.getName().equals("deserialize")) continue;
                    Type[] newtypes = m.getGenericParameterTypes();
                    try {
                        Object[] sub = new Object[newtypes.length];
                        System.arraycopy(parameters, i, sub, 0, newtypes.length);
                        sub = Marshalling.deSerializeParameters(sub, newtypes, conn);
                        DBusSerializable sz = (DBusSerializable)dsc.newInstance();
                        m.invoke((Object)sz, sub);
                        Object[] compress = new Object[parameters.length - newtypes.length + 1];
                        System.arraycopy(parameters, 0, compress, 0, i);
                        compress[i] = sz;
                        System.arraycopy(parameters, i + newtypes.length, compress, i + 1, parameters.length - i - newtypes.length);
                        parameters = compress;
                    }
                    catch (ArrayIndexOutOfBoundsException AIOOBe) {
                        if (AbstractConnection.EXCEPTION_DEBUG) {
                            // empty if block
                        }
                        throw new DBusException(MessageFormat.format(Gettext.getString("notEnoughElementsToCreateCustomObject"), parameters.length - i, newtypes.length));
                    }
                }
                continue;
            }
            parameters[i] = Marshalling.deSerializeParameter(parameters[i], types[i], conn);
        }
        return parameters;
    }
}

