/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authSession.AbstractRootAuthenticationSessionModel;
import org.keycloak.models.map.authSession.MapAuthenticationSessionAdapter;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class MapRootAuthenticationSessionAdapter
extends AbstractRootAuthenticationSessionModel<MapRootAuthenticationSessionEntity> {
    public MapRootAuthenticationSessionAdapter(KeycloakSession session, RealmModel realm, MapRootAuthenticationSessionEntity entity) {
        super(session, realm, entity);
    }

    public String getId() {
        return ((MapRootAuthenticationSessionEntity)this.entity).getId();
    }

    public RealmModel getRealm() {
        return this.session.realms().getRealm(((MapRootAuthenticationSessionEntity)this.entity).getRealmId());
    }

    public int getTimestamp() {
        return ((MapRootAuthenticationSessionEntity)this.entity).getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        ((MapRootAuthenticationSessionEntity)this.entity).setTimestamp(timestamp);
    }

    public Map<String, AuthenticationSessionModel> getAuthenticationSessions() {
        return ((MapRootAuthenticationSessionEntity)this.entity).getAuthenticationSessions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new MapAuthenticationSessionAdapter(this.session, this, (String)entry.getKey(), (MapAuthenticationSessionEntity)entry.getValue())));
    }

    public AuthenticationSessionModel getAuthenticationSession(ClientModel client, String tabId) {
        if (client == null || tabId == null) {
            return null;
        }
        AuthenticationSessionModel authSession = this.getAuthenticationSessions().get(tabId);
        if (authSession != null && client.equals(authSession.getClient())) {
            this.session.getContext().setAuthenticationSession(authSession);
            return authSession;
        }
        return null;
    }

    public AuthenticationSessionModel createAuthenticationSession(ClientModel client) {
        Objects.requireNonNull(client, "The provided client can't be null!");
        MapAuthenticationSessionEntity authSessionEntity = new MapAuthenticationSessionEntity();
        authSessionEntity.setClientUUID(client.getId());
        int timestamp = Time.currentTime();
        authSessionEntity.setTimestamp(timestamp);
        String tabId = this.generateTabId();
        ((MapRootAuthenticationSessionEntity)this.entity).getAuthenticationSessions().put(tabId, authSessionEntity);
        ((MapRootAuthenticationSessionEntity)this.entity).setTimestamp(timestamp);
        MapAuthenticationSessionAdapter authSession = new MapAuthenticationSessionAdapter(this.session, this, tabId, authSessionEntity);
        this.session.getContext().setAuthenticationSession((AuthenticationSessionModel)authSession);
        return authSession;
    }

    public void removeAuthenticationSessionByTabId(String tabId) {
        if (((MapRootAuthenticationSessionEntity)this.entity).removeAuthenticationSession(tabId) != null) {
            if (((MapRootAuthenticationSessionEntity)this.entity).getAuthenticationSessions().isEmpty()) {
                this.session.authenticationSessions().removeRootAuthenticationSession(this.realm, (RootAuthenticationSessionModel)this);
            } else {
                ((MapRootAuthenticationSessionEntity)this.entity).setTimestamp(Time.currentTime());
            }
        }
    }

    public void restartSession(RealmModel realm) {
        ((MapRootAuthenticationSessionEntity)this.entity).clearAuthenticationSessions();
        ((MapRootAuthenticationSessionEntity)this.entity).setTimestamp(Time.currentTime());
    }

    public void setUpdated(boolean updated) {
        ((MapRootAuthenticationSessionEntity)this.entity).signalUpdated(updated);
    }

    private String generateTabId() {
        return Base64Url.encode((byte[])SecretGenerator.getInstance().randomBytes(8));
    }
}

