/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authSession.MapAuthenticationSessionAuthNoteUpdateEvent;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionAdapter;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.utils.RealmInfoUtil;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class MapRootAuthenticationSessionProvider
implements AuthenticationSessionProvider {
    private static final Logger LOG = Logger.getLogger(MapRootAuthenticationSessionProvider.class);
    private final KeycloakSession session;
    protected final MapKeycloakTransaction<MapRootAuthenticationSessionEntity, RootAuthenticationSessionModel> tx;
    private static final String AUTHENTICATION_SESSION_EVENTS = "AUTHENTICATION_SESSION_EVENTS";

    public MapRootAuthenticationSessionProvider(KeycloakSession session, MapStorage<MapRootAuthenticationSessionEntity, RootAuthenticationSessionModel> sessionStore) {
        this.session = session;
        this.tx = sessionStore.createTransaction(session);
        session.getTransactionManager().enlistAfterCompletion(this.tx);
    }

    private Function<MapRootAuthenticationSessionEntity, RootAuthenticationSessionModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapRootAuthenticationSessionAdapter(this.session, realm, (MapRootAuthenticationSessionEntity)origEntity);
    }

    private Predicate<MapRootAuthenticationSessionEntity> entityRealmFilter(String realmId) {
        if (realmId == null) {
            return c -> false;
        }
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        return this.createRootAuthenticationSession(realm, null);
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm, String id) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        LOG.tracef("createRootAuthenticationSession(%s)%s", (Object)realm.getName(), StackUtil.getShortStackTrace());
        MapRootAuthenticationSessionEntity entity = new MapRootAuthenticationSessionEntity(id, realm.getId());
        entity.setTimestamp(Time.currentTime());
        if (id != null && this.tx.read(id) != null) {
            throw new ModelDuplicateException("Root authentication session exists: " + entity.getId());
        }
        entity = this.tx.create(entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public RootAuthenticationSessionModel getRootAuthenticationSession(RealmModel realm, String authenticationSessionId) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        if (authenticationSessionId == null) {
            return null;
        }
        LOG.tracef("getRootAuthenticationSession(%s, %s)%s", (Object)realm.getName(), (Object)authenticationSessionId, StackUtil.getShortStackTrace());
        MapRootAuthenticationSessionEntity entity = this.tx.read(authenticationSessionId);
        return entity == null || !this.entityRealmFilter(realm.getId()).test(entity) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public void removeRootAuthenticationSession(RealmModel realm, RootAuthenticationSessionModel authenticationSession) {
        Objects.requireNonNull(authenticationSession, "The provided root authentication session can't be null!");
        this.tx.delete(authenticationSession.getId());
    }

    public void removeAllExpired() {
        this.session.realms().getRealmsStream().forEach(this::removeExpired);
    }

    public void removeExpired(RealmModel realm) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        LOG.debugf("Removing expired sessions", new Object[0]);
        int expired = Time.currentTime() - RealmInfoUtil.getDettachedClientSessionLifespan((RealmModel)realm);
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(RootAuthenticationSessionModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RootAuthenticationSessionModel.SearchableFields.TIMESTAMP, ModelCriteriaBuilder.Operator.LT, new Object[]{expired});
        long deletedCount = this.tx.delete(QueryParameters.withCriteria(mcb));
        LOG.debugf("Removed %d expired authentication sessions for realm '%s'", deletedCount, (Object)realm.getName());
    }

    public void onRealmRemoved(RealmModel realm) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(RootAuthenticationSessionModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.tx.delete(QueryParameters.withCriteria(mcb));
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
    }

    public void updateNonlocalSessionAuthNotes(AuthenticationSessionCompoundId compoundId, Map<String, String> authNotesFragment) {
        if (compoundId == null) {
            return;
        }
        Objects.requireNonNull(authNotesFragment, "The provided authentication's notes map can't be null!");
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        cluster.notify(AUTHENTICATION_SESSION_EVENTS, (ClusterEvent)MapAuthenticationSessionAuthNoteUpdateEvent.create(compoundId.getRootSessionId(), compoundId.getTabId(), compoundId.getClientUUID(), authNotesFragment), true, ClusterProvider.DCNotify.ALL_BUT_LOCAL_DC);
    }

    public void close() {
    }
}

