/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.authorization.MapPermissionTicketStore;
import org.keycloak.models.map.authorization.MapPolicyStore;
import org.keycloak.models.map.authorization.MapResourceServerStore;
import org.keycloak.models.map.authorization.MapResourceStore;
import org.keycloak.models.map.authorization.MapScopeStore;
import org.keycloak.models.map.storage.MapStorage;

public class MapAuthorizationStore
implements StoreFactory {
    private final PolicyStore policyStore;
    private final ResourceServerStore resourceServerStore;
    private final ResourceStore resourceStore;
    private final ScopeStore scopeStore;
    private final PermissionTicketStore permissionTicketStore;
    private boolean readOnly;

    public MapAuthorizationStore(KeycloakSession session, MapStorage permissionTicketStore, MapStorage policyStore, MapStorage resourceServerStore, MapStorage resourceStore, MapStorage scopeStore, AuthorizationProvider provider) {
        this.permissionTicketStore = new MapPermissionTicketStore(session, permissionTicketStore, provider);
        this.policyStore = new MapPolicyStore(session, policyStore, provider);
        this.resourceServerStore = new MapResourceServerStore(session, resourceServerStore, provider);
        this.resourceStore = new MapResourceStore(session, resourceStore, provider);
        this.scopeStore = new MapScopeStore(session, scopeStore, provider);
    }

    public ResourceStore getResourceStore() {
        return this.resourceStore;
    }

    public ResourceServerStore getResourceServerStore() {
        return this.resourceServerStore;
    }

    public ScopeStore getScopeStore() {
        return this.scopeStore;
    }

    public PolicyStore getPolicyStore() {
        return this.policyStore;
    }

    public PermissionTicketStore getPermissionTicketStore() {
        return this.permissionTicketStore;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void close() {
    }
}

