/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.role;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.map.role.MapRoleAdapter;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.role.MapRoleEntityImpl;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.provider.ProviderEvent;

public class MapRoleProvider
implements RoleProvider {
    private static final Logger LOG = Logger.getLogger(MapRoleProvider.class);
    private final KeycloakSession session;
    final MapKeycloakTransaction<MapRoleEntity, RoleModel> tx;

    public MapRoleProvider(KeycloakSession session, MapStorage<MapRoleEntity, RoleModel> roleStore) {
        this.session = session;
        this.tx = roleStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Function<MapRoleEntity, RoleModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapRoleAdapter(this.session, realm, (MapRoleEntity)origEntity);
    }

    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        if (this.getRealmRole(realm, name) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        LOG.tracef("addRealmRole(%s, %s, %s)%s", new Object[]{realm, id, name, StackUtil.getShortStackTrace()});
        MapRoleEntity entity = new MapRoleEntityImpl();
        entity.setId(id);
        entity.setRealmId(realm.getId());
        entity.setName(name);
        if (this.tx.read(entity.getId()) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        entity = this.tx.create(entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm, Integer first, Integer max) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.IS_CLIENT_ROLE, ModelCriteriaBuilder.Operator.NE, new Object[]{true});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<RoleModel> getRolesStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        LOG.tracef("getRolesStream(%s, %s, %s, %d, %d)%s", new Object[]{realm, ids, search, first, max, StackUtil.getShortStackTrace()});
        if (ids == null) {
            return Stream.empty();
        }
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb).compare(RoleModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.IN, new Object[]{ids})).compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        if (search != null) {
            mcb = ((DefaultModelCriteria)mcb).compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"});
        }
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.IS_CLIENT_ROLE, ModelCriteriaBuilder.Operator.NE, new Object[]{true});
        return this.tx.read(QueryParameters.withCriteria(mcb).orderBy(RoleModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING)).map(this.entityToAdapterFunc(realm));
    }

    public RoleModel addClientRole(ClientModel client, String id, String name) {
        if (this.getClientRole(client, name) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        LOG.tracef("addClientRole(%s, %s, %s)%s", new Object[]{client, id, name, StackUtil.getShortStackTrace()});
        MapRoleEntity entity = new MapRoleEntityImpl();
        entity.setId(id);
        entity.setRealmId(client.getRealm().getId());
        entity.setName(name);
        entity.setClientRole(true);
        entity.setClientId(client.getId());
        if (this.tx.read(entity.getId()) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        entity = this.tx.create(entity);
        return this.entityToAdapterFunc(client.getRealm()).apply(entity);
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client, Integer first, Integer max) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getRealm().getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(client.getRealm()));
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getRealm().getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        return this.tx.read(QueryParameters.withCriteria(mcb).orderBy(RoleModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING)).map(this.entityToAdapterFunc(client.getRealm()));
    }

    public boolean removeRole(final RoleModel role) {
        LOG.tracef("removeRole(%s(%s))%s", (Object)role.getName(), (Object)role.getId(), StackUtil.getShortStackTrace());
        RealmModel realm = role.isClientRole() ? ((ClientModel)role.getContainer()).getRealm() : (RealmModel)role.getContainer();
        this.session.users().preRemove(realm, role);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RoleContainerModel.RoleRemovedEvent(){

            public RoleModel getRole() {
                return role;
            }

            public KeycloakSession getKeycloakSession() {
                return MapRoleProvider.this.session;
            }
        });
        this.tx.delete(role.getId());
        return true;
    }

    public void removeRoles(RealmModel realm) {
        this.getRealmRolesStream(realm).forEach(this::removeRole);
    }

    public void removeRoles(ClientModel client) {
        this.getClientRolesStream(client).forEach(this::removeRole);
    }

    public RoleModel getRealmRole(RealmModel realm, String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getRealmRole(%s, %s)%s", (Object)realm, (Object)name, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{name});
        String roleId = this.tx.read(QueryParameters.withCriteria(mcb)).map(this.entityToAdapterFunc(realm)).map(RoleModel::getId).findFirst().orElse(null);
        return roleId == null ? null : this.session.roles().getRoleById(realm, roleId);
    }

    public RoleModel getClientRole(ClientModel client, String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getClientRole(%s, %s)%s", (Object)client, (Object)name, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getRealm().getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()})).compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{name});
        String roleId = this.tx.read(QueryParameters.withCriteria(mcb)).map(this.entityToAdapterFunc(client.getRealm())).map(RoleModel::getId).findFirst().orElse(null);
        return roleId == null ? null : this.session.roles().getRoleById(client.getRealm(), roleId);
    }

    public RoleModel getRoleById(RealmModel realm, String id) {
        if (id == null || realm == null || realm.getId() == null) {
            return null;
        }
        LOG.tracef("getRoleById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        MapRoleEntity entity = this.tx.read(id);
        String realmId = realm.getId();
        return entity == null || !Objects.equals(realmId, entity.getRealmId()) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<RoleModel> searchForRolesStream(RealmModel realm, String search, Integer first, Integer max) {
        if (search == null) {
            return Stream.empty();
        }
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).or(new DefaultModelCriteria[]{mcb.compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"}), mcb.compare(RoleModel.SearchableFields.DESCRIPTION, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"})});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<RoleModel> searchForClientRolesStream(ClientModel client, String search, Integer first, Integer max) {
        if (search == null) {
            return Stream.empty();
        }
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getRealm().getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()})).or(new DefaultModelCriteria[]{mcb.compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"}), mcb.compare(RoleModel.SearchableFields.DESCRIPTION, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"})});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(client.getRealm()));
    }

    public void close() {
    }
}

