/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.UpdatableEntity;

public class MapAuthenticatedClientSessionEntity
extends UpdatableEntity.Impl
implements AbstractEntity {
    private String id;
    private String userSessionId;
    private String realmId;
    private String clientId;
    private String authMethod;
    private String redirectUri;
    private volatile int timestamp;
    private long expiration;
    private String action;
    private Map<String, String> notes = new ConcurrentHashMap<String, String>();
    private String currentRefreshToken;
    private int currentRefreshTokenUseCount;
    private boolean offline;

    public MapAuthenticatedClientSessionEntity() {
    }

    public MapAuthenticatedClientSessionEntity(String id, String userSessionId, String realmId, String clientId, boolean offline) {
        this.id = id;
        this.userSessionId = userSessionId;
        this.realmId = realmId;
        this.clientId = clientId;
        this.offline = offline;
        this.timestamp = Time.currentTime();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        if (this.id != null) {
            throw new IllegalStateException("Id cannot be changed");
        }
        this.id = id;
        this.updated |= id != null;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.updated |= !Objects.equals(this.realmId, realmId);
        this.realmId = realmId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.updated |= !Objects.equals(this.clientId, clientId);
        this.clientId = clientId;
    }

    public String getUserSessionId() {
        return this.userSessionId;
    }

    public void setUserSessionId(String userSessionId) {
        this.updated |= !Objects.equals(this.userSessionId, userSessionId);
        this.userSessionId = userSessionId;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.updated |= !Objects.equals(this.authMethod, authMethod);
        this.authMethod = authMethod;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.updated |= !Objects.equals(this.redirectUri, redirectUri);
        this.redirectUri = redirectUri;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.updated |= this.timestamp != timestamp;
        this.timestamp = timestamp;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.updated |= this.expiration != expiration;
        this.expiration = expiration;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.updated |= !Objects.equals(this.action, action);
        this.action = action;
    }

    public Map<String, String> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, String> notes) {
        this.updated |= !Objects.equals(this.notes, notes);
        this.notes = notes;
    }

    public String removeNote(String name) {
        String note = this.notes.remove(name);
        this.updated |= note != null;
        return note;
    }

    public void addNote(String name, String value) {
        this.updated |= !Objects.equals(this.notes.put(name, value), value);
    }

    public String getCurrentRefreshToken() {
        return this.currentRefreshToken;
    }

    public void setCurrentRefreshToken(String currentRefreshToken) {
        this.updated |= !Objects.equals(this.currentRefreshToken, currentRefreshToken);
        this.currentRefreshToken = currentRefreshToken;
    }

    public int getCurrentRefreshTokenUseCount() {
        return this.currentRefreshTokenUseCount;
    }

    public void setCurrentRefreshTokenUseCount(int currentRefreshTokenUseCount) {
        this.updated |= this.currentRefreshTokenUseCount != currentRefreshTokenUseCount;
        this.currentRefreshTokenUseCount = currentRefreshTokenUseCount;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.updated |= this.offline != offline;
        this.offline = offline;
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), this.hashCode());
    }
}

