/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.utils;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.kie.api.KieServices;
import org.kie.api.Service;
import org.kie.api.builder.KieScannerFactoryService;
import org.kie.api.concurrent.KieExecutors;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.internal.assembler.KieAssemblers;
import org.kie.internal.assembler.KieAssemblersImpl;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.runtime.KieRuntimes;
import org.kie.internal.runtime.KieRuntimesImpl;
import org.kie.internal.runtime.beliefs.KieBeliefs;
import org.kie.internal.runtime.beliefs.KieBeliefsImpl;
import org.kie.internal.utils.ClassLoaderResolver;
import org.kie.internal.utils.ClassLoaderUtil;
import org.kie.internal.utils.ServiceDiscovery;
import org.kie.internal.utils.ServiceRegistry;
import org.kie.internal.weaver.KieWeavers;
import org.kie.internal.weaver.KieWeaversImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryImpl
implements ServiceRegistry {
    public final String fileName = "kie.conf";
    public final String path = "META-INF/kie.conf";
    private static final ServiceRegistry instance = new ServiceRegistryImpl();
    protected static final transient Logger logger = LoggerFactory.getLogger(ServiceRegistryImpl.class);
    private final Map<String, Callable<?>> registry = new HashMap();
    private final Map<String, Callable<?>> defaultServices = new HashMap();

    public static synchronized ServiceRegistry getInstance() {
        return instance;
    }

    public ServiceRegistryImpl() {
        this.init();
    }

    @Override
    public synchronized void registerLocator(Class cls, Callable cal) {
        this.registry.put(cls.getName(), cal);
    }

    @Override
    public synchronized void unregisterLocator(Class cls) {
        this.registry.remove(cls.getName());
    }

    synchronized void registerInstance(Service service, Map map) {
        String[] values;
        logger.info("regInstance : " + map);
        for (String v : values = (String[])map.get("objectClass")) {
            logger.info(v);
        }
        this.registry.put(service.getClass().getInterfaces()[0].getName(), new ReturnInstance(service));
    }

    synchronized void unregisterInstance(Service service, Map map) {
        logger.info("unregister : " + map);
        String name = service.getClass().getInterfaces()[0].getName();
        this.registry.remove(name);
        this.registry.put(name, this.defaultServices.get(name));
    }

    @Override
    public synchronized <T> T get(Class<T> cls) {
        Callable<?> cal = this.registry.get(cls.getName());
        if (cal != null) {
            try {
                return cls.cast(cal.call());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate service for Class '" + (cls != null ? cls.getName() : null) + "'", e);
            }
        }
        cal = this.defaultServices.get(cls.getName());
        try {
            return cls.cast(cal.call());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate service for Class '" + (cls != null ? cls.getName() : null) + "'", e);
        }
    }

    private void init() {
        this.addDefault("org.kie.internal.builder.KnowledgeBuilderFactoryService", "org.drools.compiler.builder.impl.KnowledgeBuilderFactoryServiceImpl");
        this.addDefault("org.kie.api.builder.KnowledgeContainerFactoryService", "org.drools.core.builder.impl.KnowledgeContainerFactoryServiceImpl");
        this.addDefault("org.kie.internal.KnowledgeBaseFactoryService", "org.drools.core.impl.KnowledgeBaseFactoryServiceImpl");
        this.addDefault("org.kie.internal.io.ResourceFactoryService", "org.drools.core.io.impl.ResourceFactoryServiceImpl");
        this.addDefault("org.kie.internal.SystemEventListenerService", "org.drools.core.impl.SystemEventListenerServiceImpl");
        this.addDefault(KieMarshallers.class, "org.drools.core.marshalling.impl.MarshallerProviderImpl");
        this.addDefault(KieExecutors.class, "org.drools.core.concurrent.ExecutorProviderImpl");
        this.addDefault(KieServices.class, "org.drools.compiler.kie.builder.impl.KieServicesImpl");
        this.addDefaultFactory(KieScannerFactoryService.class, "org.kie.scanner.KieScannerFactoryServiceImpl");
        this.addDefault(KieStoreServices.class, "org.drools.persistence.jpa.KnowledgeStoreServiceImpl");
        this.addDefault(CorrelationKeyFactory.class, "org.jbpm.persistence.correlation.JPACorrelationKeyFactory");
        this.addDefault(ClassLoaderResolver.class, "org.kie.scanner.MavenClassLoaderResolver");
        this.addDefault(ServiceDiscovery.class, "org.drools.core.util.ServiceDiscoveryImpl");
        this.defaultServices.put(KieAssemblers.class.getName(), new ReturnInstance(new KieAssemblersImpl()));
        this.defaultServices.put(KieWeavers.class.getName(), new ReturnInstance(new KieWeaversImpl()));
        this.defaultServices.put(KieRuntimes.class.getName(), new ReturnInstance(new KieRuntimesImpl()));
        this.defaultServices.put(KieBeliefs.class.getName(), new ReturnInstance(new KieBeliefsImpl()));
        this.initServiceDiscovery();
    }

    private void initServiceDiscovery() {
        try {
            Enumeration<URL> confResources = ServiceRegistryImpl.getClassLoader().getResources("META-INF/kie.conf");
            if (confResources.hasMoreElements()) {
                this.get(ServiceDiscovery.class).discoverFactories(confResources, this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void addDefault(Class cls, String impl) {
        this.addDefault(cls.getName(), impl);
    }

    private synchronized void addDefault(String service, String impl) {
        ReflectionInstantiator resourceRi = new ReflectionInstantiator(impl);
        this.defaultServices.put(service, resourceRi);
    }

    public synchronized void addDefaultFactory(Class cls, String impl) {
        this.addDefaultFactory(cls.getName(), impl);
    }

    private synchronized void addDefaultFactory(String service, String impl) {
        FactoryInstantiator resourceRi = new FactoryInstantiator(impl);
        this.defaultServices.put(service, resourceRi);
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            cl = ClassLoaderUtil.class.getClassLoader();
        }
        return cl;
    }

    public static class ReturnInstance<V>
    implements Callable<V> {
        private final Service service;

        public ReturnInstance(Service service) {
            this.service = service;
        }

        @Override
        public V call() throws Exception {
            return (V)this.service;
        }
    }

    public static class FactoryInstantiator<V>
    implements Callable<V> {
        private final String name;
        private final AtomicReference<V> service = new AtomicReference();

        public FactoryInstantiator(String name) {
            this.name = name;
        }

        @Override
        public V call() throws Exception {
            if (this.service.get() == null) {
                try {
                    Class<?> cls = Class.forName(this.name);
                    this.service.compareAndSet(null, cls.newInstance());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to instantiate '" + this.name + "'", e);
                }
            }
            return this.service.get();
        }
    }

    public static class ReflectionInstantiator<V>
    implements Callable<V> {
        private final String name;

        public ReflectionInstantiator(String name) {
            this.name = name;
        }

        @Override
        public V call() throws Exception {
            return (V)ReflectionInstantiator.newInstance(this.name);
        }

        static <T> T newInstance(String name) {
            try {
                Class<?> cls = Class.forName(name);
                return (T)cls.newInstance();
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Unable to instantiate '" + name + "'", e2);
            }
        }
    }
}

