/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.servlet.AbstractFilterPipeline;
import com.google.inject.servlet.FilterDefinition;
import com.google.inject.servlet.ManagedServletPipeline;
import java.util.ArrayList;
import javax.servlet.ServletContext;

@Singleton
class ManagedFilterPipeline
extends AbstractFilterPipeline {
    private final FilterDefinition[] filterDefinitions;
    private static final TypeLiteral<FilterDefinition> FILTER_DEFS = TypeLiteral.get(FilterDefinition.class);

    @Inject
    public ManagedFilterPipeline(Injector injector, ManagedServletPipeline servletPipeline, Provider<ServletContext> servletContext) {
        super(injector, servletPipeline, servletContext);
        this.filterDefinitions = ManagedFilterPipeline.collectFilterDefinitions(injector);
    }

    @Override
    protected boolean hasFiltersMapped() {
        return this.filterDefinitions.length > 0;
    }

    @Override
    protected FilterDefinition[] filterDefinitions() {
        return this.filterDefinitions;
    }

    private static FilterDefinition[] collectFilterDefinitions(Injector injector) {
        ArrayList filterDefinitions = Lists.newArrayList();
        for (Binding entry : injector.findBindingsByType(FILTER_DEFS)) {
            filterDefinitions.add(entry.getProvider().get());
        }
        return filterDefinitions.toArray(new FilterDefinition[filterDefinitions.size()]);
    }
}

