/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential.hash;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.keycloak.Config;
import org.keycloak.common.util.Base64;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.credential.hash.PasswordHashProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.PasswordPolicy;

public class Pbkdf2PasswordHashProvider
implements PasswordHashProviderFactory,
PasswordHashProvider {
    public static final String ID = "pbkdf2";
    private static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final int DERIVED_KEY_SIZE = 512;

    public CredentialModel encode(String rawPassword, int iterations) {
        byte[] salt = this.getSalt();
        String encodedPassword = this.encode(rawPassword, iterations, salt);
        CredentialModel credentials = new CredentialModel();
        credentials.setAlgorithm(ID);
        credentials.setType("password");
        credentials.setSalt(salt);
        credentials.setHashIterations(iterations);
        credentials.setValue(encodedPassword);
        return credentials;
    }

    public boolean policyCheck(PasswordPolicy policy, CredentialModel credential) {
        return credential.getHashIterations() == policy.getHashIterations() && ID.equals(credential.getAlgorithm());
    }

    public void encode(String rawPassword, PasswordPolicy policy, CredentialModel credential) {
        byte[] salt = this.getSalt();
        String encodedPassword = this.encode(rawPassword, policy.getHashIterations(), salt);
        credential.setAlgorithm(ID);
        credential.setType("password");
        credential.setSalt(salt);
        credential.setHashIterations(policy.getHashIterations());
        credential.setValue(encodedPassword);
    }

    public boolean verify(String rawPassword, CredentialModel credential) {
        return this.encode(rawPassword, credential.getHashIterations(), credential.getSalt()).equals(credential.getValue());
    }

    public PasswordHashProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }

    private String encode(String rawPassword, int iterations, byte[] salt) {
        PBEKeySpec spec = new PBEKeySpec(rawPassword.toCharArray(), salt, iterations, 512);
        try {
            byte[] key = this.getSecretKeyFactory().generateSecret(spec).getEncoded();
            return Base64.encodeBytes((byte[])key);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Credential could not be encoded", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private byte[] getSalt() {
        byte[] buffer = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(buffer);
        return buffer;
    }

    private SecretKeyFactory getSecretKeyFactory() {
        try {
            return SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("PBKDF2 algorithm not found", e);
        }
    }
}

