/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.util.JsonSerialization;

public class PolicyResourceService {
    private final Policy policy;
    protected final ResourceServer resourceServer;
    protected final AuthorizationProvider authorization;
    protected final RealmAuth auth;

    public PolicyResourceService(Policy policy, ResourceServer resourceServer, AuthorizationProvider authorization, RealmAuth auth) {
        this.policy = policy;
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoCache
    public Response update(String payload) {
        this.auth.requireManage();
        AbstractPolicyRepresentation representation = this.doCreateRepresentation(payload);
        if (this.policy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        representation.setId(this.policy.getId());
        RepresentationToModel.toModel((AbstractPolicyRepresentation)representation, (AuthorizationProvider)this.authorization, (Policy)this.policy);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    public Response delete() {
        this.auth.requireManage();
        if (this.policy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        PolicyProviderFactory resource = this.getProviderFactory(this.policy.getType());
        resource.onRemove(this.policy, this.authorization);
        policyStore.delete(this.policy.getId());
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response findById() {
        this.auth.requireView();
        if (this.policy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)this.toRepresentation(this.policy, this.authorization)).build();
    }

    protected AbstractPolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        return ModelToRepresentation.toRepresentation((Policy)policy, PolicyRepresentation.class, (AuthorizationProvider)authorization);
    }

    @Path(value="/dependentPolicies")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response getDependentPolicies() {
        this.auth.requireView();
        if (this.policy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List policies = this.authorization.getStoreFactory().getPolicyStore().findDependentPolicies(this.policy.getId(), this.resourceServer.getId());
        return Response.ok(policies.stream().map(policy -> {
            PolicyRepresentation representation1 = new PolicyRepresentation();
            representation1.setId(policy.getId());
            representation1.setName(policy.getName());
            representation1.setType(policy.getType());
            return representation1;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="/scopes")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response getScopes() {
        this.auth.requireView();
        if (this.policy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(this.policy.getScopes().stream().map(scope -> {
            ScopeRepresentation representation = new ScopeRepresentation();
            representation.setId(scope.getId());
            representation.setName(scope.getName());
            return representation;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="/resources")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response getResources() {
        this.auth.requireView();
        if (this.policy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(this.policy.getResources().stream().map(resource -> {
            ResourceRepresentation representation = new ResourceRepresentation();
            representation.setId(resource.getId());
            representation.setName(resource.getName());
            return representation;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="/associatedPolicies")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response getAssociatedPolicies() {
        this.auth.requireView();
        if (this.policy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(this.policy.getAssociatedPolicies().stream().map(policy -> {
            PolicyRepresentation representation1 = new PolicyRepresentation();
            representation1.setId(policy.getId());
            representation1.setName(policy.getName());
            representation1.setType(policy.getType());
            return representation1;
        }).collect(Collectors.toList())).build();
    }

    protected AbstractPolicyRepresentation doCreateRepresentation(String payload) {
        PolicyRepresentation representation;
        try {
            representation = (PolicyRepresentation)JsonSerialization.readValue((String)payload, PolicyRepresentation.class);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize representation", cause);
        }
        return representation;
    }

    private PolicyProviderFactory getProviderFactory(String policyType) {
        return this.authorization.getProviderFactory(policyType);
    }

    protected Policy getPolicy() {
        return this.policy;
    }
}

