/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.entitlement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.common.KeycloakEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.entitlement.representation.EntitlementRequest;
import org.keycloak.authorization.entitlement.representation.EntitlementResponse;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.Cors;

public class EntitlementService {
    private final AuthorizationProvider authorization;
    @Context
    private HttpRequest request;
    @Context
    private KeycloakSession session;

    public EntitlementService(AuthorizationProvider authorization) {
        this.authorization = authorization;
    }

    @Path(value="{resource_server_id}")
    @OPTIONS
    public Response authorizePreFlight(@PathParam(value="resource_server_id") String resourceServerId) {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="{resource_server_id}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public void getAll(@PathParam(value="resource_server_id") String resourceServerId, final @Suspended AsyncResponse asyncResponse) {
        final KeycloakIdentity identity = new KeycloakIdentity(this.authorization.getKeycloakSession());
        if (resourceServerId == null) {
            throw new ErrorResponseException("invalid_request", "Requires resource_server_id request parameter.", Response.Status.BAD_REQUEST);
        }
        RealmModel realm = this.authorization.getKeycloakSession().getContext().getRealm();
        ClientModel client = realm.getClientByClientId(resourceServerId);
        if (client == null) {
            throw new ErrorResponseException("invalid_request", "Identifier is not associated with any client and resource server.", Response.Status.BAD_REQUEST);
        }
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        final ResourceServer resourceServer = storeFactory.getResourceServerStore().findByClient(client.getId());
        this.authorization.evaluators().from(Permissions.all(resourceServer, identity, this.authorization), (EvaluationContext)new KeycloakEvaluationContext(this.authorization.getKeycloakSession())).evaluate((Decision)new DecisionResultCollector(){

            public void onError(Throwable cause) {
                asyncResponse.resume(cause);
            }

            protected void onComplete(List<Result> results) {
                List<Permission> entitlements = Permissions.permits(results, EntitlementService.this.authorization, resourceServer.getId());
                if (entitlements.isEmpty()) {
                    HashMap<String, String> error = new HashMap<String, String>();
                    error.put("error", "not_authorized");
                    asyncResponse.resume((Object)Cors.add(EntitlementService.this.request, Response.status((Response.Status)Response.Status.FORBIDDEN).entity(error)).allowedOrigins(identity.getAccessToken()).exposedHeaders("Access-Control-Allow-Methods").build());
                } else {
                    asyncResponse.resume((Object)Cors.add(EntitlementService.this.request, Response.ok().entity((Object)new EntitlementResponse(EntitlementService.this.createRequestingPartyToken(entitlements, identity.getAccessToken())))).allowedOrigins(identity.getAccessToken()).allowedMethods("GET").exposedHeaders("Access-Control-Allow-Methods").build());
                }
            }
        });
    }

    @Path(value="{resource_server_id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void get(@PathParam(value="resource_server_id") String resourceServerId, EntitlementRequest entitlementRequest, final @Suspended AsyncResponse asyncResponse) {
        final KeycloakIdentity identity = new KeycloakIdentity(this.authorization.getKeycloakSession());
        if (entitlementRequest == null) {
            throw new ErrorResponseException("invalid_request", "Invalid entitlement request.", Response.Status.BAD_REQUEST);
        }
        if (resourceServerId == null) {
            throw new ErrorResponseException("invalid_request", "Invalid resource_server_id.", Response.Status.BAD_REQUEST);
        }
        RealmModel realm = this.authorization.getKeycloakSession().getContext().getRealm();
        ClientModel client = realm.getClientByClientId(resourceServerId);
        if (client == null) {
            throw new ErrorResponseException("invalid_request", "Identifier is not associated with any resource server.", Response.Status.BAD_REQUEST);
        }
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        final ResourceServer resourceServer = storeFactory.getResourceServerStore().findByClient(client.getId());
        try {
            this.authorization.evaluators().from(this.createPermissions(entitlementRequest, resourceServer, this.authorization), (EvaluationContext)new KeycloakEvaluationContext(this.authorization.getKeycloakSession())).evaluate((Decision)new DecisionResultCollector(){

                public void onError(Throwable cause) {
                    asyncResponse.resume(cause);
                }

                protected void onComplete(List<Result> results) {
                    List<Permission> entitlements = Permissions.permits(results, EntitlementService.this.authorization, resourceServer.getId());
                    if (entitlements.isEmpty()) {
                        HashMap<String, String> error = new HashMap<String, String>();
                        error.put("error", "not_authorized");
                        asyncResponse.resume((Object)Cors.add(EntitlementService.this.request, Response.status((Response.Status)Response.Status.FORBIDDEN).entity(error)).allowedOrigins(identity.getAccessToken()).exposedHeaders("Access-Control-Allow-Methods").build());
                    } else {
                        asyncResponse.resume((Object)Cors.add(EntitlementService.this.request, Response.ok().entity((Object)new EntitlementResponse(EntitlementService.this.createRequestingPartyToken(entitlements, identity.getAccessToken())))).allowedOrigins(identity.getAccessToken()).allowedMethods("GET").exposedHeaders("Access-Control-Allow-Methods").build());
                    }
                }
            });
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Could not process authorization request";
            }
            asyncResponse.resume((Object)ErrorResponse.error(message, Response.Status.BAD_REQUEST));
        }
    }

    private String createRequestingPartyToken(List<Permission> permissions, AccessToken accessToken) {
        RealmModel realm = this.authorization.getKeycloakSession().getContext().getRealm();
        AccessToken.Authorization authorization = new AccessToken.Authorization();
        authorization.setPermissions(permissions);
        accessToken.setAuthorization(authorization);
        return new TokenManager().encodeToken(this.authorization.getKeycloakSession(), realm, accessToken);
    }

    private List<ResourcePermission> createPermissions(EntitlementRequest entitlementRequest, ResourceServer resourceServer, AuthorizationProvider authorization) {
        StoreFactory storeFactory = authorization.getStoreFactory();
        HashMap permissionsToEvaluate = new HashMap();
        entitlementRequest.getPermissions().forEach(requestedResource -> {
            Resource resource = requestedResource.getResourceSetId() != null ? storeFactory.getResourceStore().findById(requestedResource.getResourceSetId(), resourceServer.getId()) : storeFactory.getResourceStore().findByName(requestedResource.getResourceSetName(), resourceServer.getId());
            if (resource == null && (requestedResource.getScopes() == null || requestedResource.getScopes().isEmpty())) {
                throw new ErrorResponseException("invalid_resource", "Resource with id [" + requestedResource.getResourceSetId() + "] or name [" + requestedResource.getResourceSetName() + "] does not exist.", Response.Status.FORBIDDEN);
            }
            Set requestedScopes = requestedResource.getScopes().stream().map(ScopeRepresentation::new).collect(Collectors.toSet());
            Set collect = requestedScopes.stream().map(ScopeRepresentation::getName).collect(Collectors.toSet());
            if (resource != null) {
                permissionsToEvaluate.put(resource.getId(), collect);
            } else {
                ResourceStore resourceStore = authorization.getStoreFactory().getResourceStore();
                ScopeStore scopeStore = authorization.getStoreFactory().getScopeStore();
                ArrayList resources = new ArrayList();
                resources.addAll(resourceStore.findByScope(requestedScopes.stream().map(scopeRepresentation -> {
                    Scope scope = scopeStore.findByName(scopeRepresentation.getName(), resourceServer.getId());
                    if (scope == null) {
                        return null;
                    }
                    return scope.getId();
                }).filter(s -> s != null).collect(Collectors.toList()), resourceServer.getId()));
                for (Resource resource1 : resources) {
                    permissionsToEvaluate.put(resource1.getId(), collect);
                }
                permissionsToEvaluate.put("$KC_SCOPE_PERMISSION", collect);
            }
        });
        String rpt = entitlementRequest.getRpt();
        if (rpt != null && !"".equals(rpt)) {
            List permissions;
            AccessToken.Authorization authorizationData;
            AccessToken requestingPartyToken;
            KeycloakContext context = authorization.getKeycloakSession().getContext();
            if (!Tokens.verifySignature(this.session, context.getRealm(), rpt)) {
                throw new ErrorResponseException("invalid_rpt", "RPT signature is invalid", Response.Status.FORBIDDEN);
            }
            try {
                requestingPartyToken = (AccessToken)new JWSInput(rpt).readJsonContent(AccessToken.class);
            }
            catch (JWSInputException e) {
                throw new ErrorResponseException("invalid_rpt", "Invalid RPT", Response.Status.FORBIDDEN);
            }
            if (requestingPartyToken.isActive() && (authorizationData = requestingPartyToken.getAuthorization()) != null && (permissions = authorizationData.getPermissions()) != null) {
                permissions.forEach(permission -> {
                    Resource resourcePermission = storeFactory.getResourceStore().findById(permission.getResourceSetId(), resourceServer.getId());
                    if (resourcePermission != null) {
                        Set scopePermission;
                        HashSet scopes = (HashSet)permissionsToEvaluate.get(resourcePermission.getId());
                        if (scopes == null) {
                            scopes = new HashSet();
                            permissionsToEvaluate.put(resourcePermission.getId(), scopes);
                        }
                        if ((scopePermission = permission.getScopes()) != null) {
                            scopes.addAll(scopePermission);
                        }
                    }
                });
            }
        }
        return permissionsToEvaluate.entrySet().stream().flatMap(entry -> {
            String key = (String)entry.getKey();
            if ("$KC_SCOPE_PERMISSION".equals(key)) {
                ScopeStore scopeStore = authorization.getStoreFactory().getScopeStore();
                List scopes = ((Set)entry.getValue()).stream().map(scopeName -> {
                    Scope byName = scopeStore.findByName(scopeName, resourceServer.getId());
                    return byName;
                }).collect(Collectors.toList());
                return Arrays.asList(new ResourcePermission(null, scopes, resourceServer)).stream();
            }
            Resource entryResource = storeFactory.getResourceStore().findById(key, resourceServer.getId());
            return Permissions.createResourcePermissions(entryResource, (Set)entry.getValue(), authorization).stream();
        }).collect(Collectors.toList());
    }
}

