/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.adapters.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.keycloak.representations.adapters.config.AdapterHttpClientConfig;
import org.keycloak.representations.adapters.config.BaseAdapterConfig;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

@JsonPropertyOrder(value={"realm", "realm-public-key", "auth-server-url", "ssl-required", "resource", "public-client", "credentials", "use-resource-role-mappings", "enable-cors", "cors-max-age", "cors-allowed-methods", "expose-token", "bearer-only", "autodetect-bearer-only", "connection-pool-size", "allow-any-hostname", "disable-trust-manager", "truststore", "truststore-password", "client-keystore", "client-keystore-password", "client-key-password", "always-refresh-token", "register-node-at-startup", "register-node-period", "token-store", "principal-attribute", "proxy-url", "turn-off-change-session-id-on-login", "token-minimum-time-to-live", "min-time-between-jwks-requests", "public-key-cache-ttl", "policy-enforcer"})
public class AdapterConfig
extends BaseAdapterConfig
implements AdapterHttpClientConfig {
    @JsonProperty(value="allow-any-hostname")
    protected boolean allowAnyHostname;
    @JsonProperty(value="disable-trust-manager")
    protected boolean disableTrustManager;
    @JsonProperty(value="truststore")
    protected String truststore;
    @JsonProperty(value="truststore-password")
    protected String truststorePassword;
    @JsonProperty(value="client-keystore")
    protected String clientKeystore;
    @JsonProperty(value="client-keystore-password")
    protected String clientKeystorePassword;
    @JsonProperty(value="client-key-password")
    protected String clientKeyPassword;
    @JsonProperty(value="connection-pool-size")
    protected int connectionPoolSize = 20;
    @JsonProperty(value="always-refresh-token")
    protected boolean alwaysRefreshToken = false;
    @JsonProperty(value="register-node-at-startup")
    protected boolean registerNodeAtStartup = false;
    @JsonProperty(value="register-node-period")
    protected int registerNodePeriod = -1;
    @JsonProperty(value="token-store")
    protected String tokenStore;
    @JsonProperty(value="principal-attribute")
    protected String principalAttribute;
    @JsonProperty(value="turn-off-change-session-id-on-login")
    protected Boolean turnOffChangeSessionIdOnLogin;
    @JsonProperty(value="token-minimum-time-to-live")
    protected int tokenMinimumTimeToLive = 0;
    @JsonProperty(value="min-time-between-jwks-requests")
    protected int minTimeBetweenJwksRequests = 10;
    @JsonProperty(value="public-key-cache-ttl")
    protected int publicKeyCacheTtl = 86400;
    @JsonProperty(value="policy-enforcer")
    protected PolicyEnforcerConfig policyEnforcerConfig;
    @JsonProperty(value="enable-pkce")
    protected boolean pkce = false;
    @JsonProperty(value="proxy-url")
    protected String proxyUrl;

    @Override
    public boolean isAllowAnyHostname() {
        return this.allowAnyHostname;
    }

    public void setAllowAnyHostname(boolean allowAnyHostname) {
        this.allowAnyHostname = allowAnyHostname;
    }

    @Override
    public boolean isDisableTrustManager() {
        return this.disableTrustManager;
    }

    public void setDisableTrustManager(boolean disableTrustManager) {
        this.disableTrustManager = disableTrustManager;
    }

    @Override
    public String getTruststore() {
        return this.truststore;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }

    @Override
    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    @Override
    public String getClientKeystore() {
        return this.clientKeystore;
    }

    public void setClientKeystore(String clientKeystore) {
        this.clientKeystore = clientKeystore;
    }

    @Override
    public String getClientKeystorePassword() {
        return this.clientKeystorePassword;
    }

    public void setClientKeystorePassword(String clientKeystorePassword) {
        this.clientKeystorePassword = clientKeystorePassword;
    }

    public String getClientKeyPassword() {
        return this.clientKeyPassword;
    }

    public void setClientKeyPassword(String clientKeyPassword) {
        this.clientKeyPassword = clientKeyPassword;
    }

    @Override
    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public boolean isAlwaysRefreshToken() {
        return this.alwaysRefreshToken;
    }

    public void setAlwaysRefreshToken(boolean alwaysRefreshToken) {
        this.alwaysRefreshToken = alwaysRefreshToken;
    }

    public boolean isRegisterNodeAtStartup() {
        return this.registerNodeAtStartup;
    }

    public void setRegisterNodeAtStartup(boolean registerNodeAtStartup) {
        this.registerNodeAtStartup = registerNodeAtStartup;
    }

    public int getRegisterNodePeriod() {
        return this.registerNodePeriod;
    }

    public void setRegisterNodePeriod(int registerNodePeriod) {
        this.registerNodePeriod = registerNodePeriod;
    }

    public String getTokenStore() {
        return this.tokenStore;
    }

    public void setTokenStore(String tokenStore) {
        this.tokenStore = tokenStore;
    }

    public String getPrincipalAttribute() {
        return this.principalAttribute;
    }

    public void setPrincipalAttribute(String principalAttribute) {
        this.principalAttribute = principalAttribute;
    }

    public Boolean getTurnOffChangeSessionIdOnLogin() {
        return this.turnOffChangeSessionIdOnLogin;
    }

    public void setTurnOffChangeSessionIdOnLogin(Boolean turnOffChangeSessionIdOnLogin) {
        this.turnOffChangeSessionIdOnLogin = turnOffChangeSessionIdOnLogin;
    }

    public PolicyEnforcerConfig getPolicyEnforcerConfig() {
        return this.policyEnforcerConfig;
    }

    public void setPolicyEnforcerConfig(PolicyEnforcerConfig policyEnforcerConfig) {
        this.policyEnforcerConfig = policyEnforcerConfig;
    }

    @Override
    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public int getTokenMinimumTimeToLive() {
        return this.tokenMinimumTimeToLive;
    }

    public void setTokenMinimumTimeToLive(int tokenMinimumTimeToLive) {
        this.tokenMinimumTimeToLive = tokenMinimumTimeToLive;
    }

    public int getMinTimeBetweenJwksRequests() {
        return this.minTimeBetweenJwksRequests;
    }

    public void setMinTimeBetweenJwksRequests(int minTimeBetweenJwksRequests) {
        this.minTimeBetweenJwksRequests = minTimeBetweenJwksRequests;
    }

    public int getPublicKeyCacheTtl() {
        return this.publicKeyCacheTtl;
    }

    public void setPublicKeyCacheTtl(int publicKeyCacheTtl) {
        this.publicKeyCacheTtl = publicKeyCacheTtl;
    }

    public boolean isPkce() {
        return this.pkce;
    }

    public void setPkce(boolean pkce) {
        this.pkce = pkce;
    }
}

