/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.infinispan.KeycloakHotRodMarshallerFactory;
import org.keycloak.connections.infinispan.DefaultInfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class DefaultInfinispanConnectionProviderFactory
implements InfinispanConnectionProviderFactory {
    protected static final Logger logger = Logger.getLogger(DefaultInfinispanConnectionProviderFactory.class);
    protected Config.Scope config;
    protected EmbeddedCacheManager cacheManager;
    protected boolean containerManaged;

    public InfinispanConnectionProvider create(KeycloakSession session) {
        this.lazyInit();
        return new DefaultInfinispanConnectionProvider(this.cacheManager);
    }

    public void close() {
        if (this.cacheManager != null && !this.containerManaged) {
            this.cacheManager.stop();
        }
        this.cacheManager = null;
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInit() {
        if (this.cacheManager == null) {
            DefaultInfinispanConnectionProviderFactory defaultInfinispanConnectionProviderFactory = this;
            synchronized (defaultInfinispanConnectionProviderFactory) {
                if (this.cacheManager == null) {
                    String cacheContainer = this.config.get("cacheContainer");
                    if (cacheContainer != null) {
                        this.initContainerManaged(cacheContainer);
                    } else {
                        this.initEmbedded();
                    }
                }
            }
        }
    }

    protected void initContainerManaged(String cacheContainerLookup) {
        try {
            this.cacheManager = (EmbeddedCacheManager)new InitialContext().lookup(cacheContainerLookup);
            this.containerManaged = true;
            long realmRevisionsMaxEntries = this.cacheManager.getCache("realms").getCacheConfiguration().eviction().maxEntries();
            realmRevisionsMaxEntries = realmRevisionsMaxEntries > 0L ? 2L * realmRevisionsMaxEntries : 20000L;
            this.cacheManager.defineConfiguration("realmRevisions", this.getRevisionCacheConfig(realmRevisionsMaxEntries));
            this.cacheManager.getCache("realmRevisions", true);
            long userRevisionsMaxEntries = this.cacheManager.getCache("users").getCacheConfiguration().eviction().maxEntries();
            userRevisionsMaxEntries = userRevisionsMaxEntries > 0L ? 2L * userRevisionsMaxEntries : 100000L;
            this.cacheManager.defineConfiguration("userRevisions", this.getRevisionCacheConfig(userRevisionsMaxEntries));
            this.cacheManager.getCache("userRevisions", true);
            this.cacheManager.getCache("authorization", true);
            this.cacheManager.getCache("keys", true);
            logger.debugv("Using container managed Infinispan cache container, lookup={1}", (Object)cacheContainerLookup);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve cache container", e);
        }
    }

    protected void initEmbedded() {
        boolean jdgEnabled;
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        boolean clustered = this.config.getBoolean("clustered", Boolean.valueOf(false));
        boolean async = this.config.getBoolean("async", Boolean.valueOf(false));
        boolean allowDuplicateJMXDomains = this.config.getBoolean("allowDuplicateJMXDomains", Boolean.valueOf(true));
        if (clustered) {
            gcb.transport().defaultTransport();
        }
        gcb.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(allowDuplicateJMXDomains));
        this.cacheManager = new DefaultCacheManager(gcb.build());
        this.containerManaged = false;
        logger.debug((Object)"Started embedded Infinispan cache container");
        ConfigurationBuilder modelCacheConfigBuilder = new ConfigurationBuilder();
        Configuration modelCacheConfiguration = modelCacheConfigBuilder.build();
        this.cacheManager.defineConfiguration("realms", modelCacheConfiguration);
        this.cacheManager.defineConfiguration("users", modelCacheConfiguration);
        ConfigurationBuilder sessionConfigBuilder = new ConfigurationBuilder();
        if (clustered) {
            String sessionsMode = this.config.get("sessionsMode", "distributed");
            if (sessionsMode.equalsIgnoreCase("replicated")) {
                sessionConfigBuilder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
            } else if (sessionsMode.equalsIgnoreCase("distributed")) {
                sessionConfigBuilder.clustering().cacheMode(async ? CacheMode.DIST_ASYNC : CacheMode.DIST_SYNC);
            } else {
                throw new RuntimeException("Invalid value for sessionsMode");
            }
            int l1Lifespan = this.config.getInt("l1Lifespan", Integer.valueOf(600000));
            boolean l1Enabled = l1Lifespan > 0;
            sessionConfigBuilder.clustering().hash().numOwners(this.config.getInt("sessionsOwners", Integer.valueOf(2)).intValue()).numSegments(this.config.getInt("sessionsSegments", Integer.valueOf(60)).intValue()).l1().enabled(l1Enabled).lifespan((long)l1Lifespan).build();
        }
        Configuration sessionCacheConfiguration = sessionConfigBuilder.build();
        this.cacheManager.defineConfiguration("sessions", sessionCacheConfiguration);
        this.cacheManager.defineConfiguration("offlineSessions", sessionCacheConfiguration);
        this.cacheManager.defineConfiguration("loginFailures", sessionCacheConfiguration);
        this.cacheManager.defineConfiguration("authorization", sessionCacheConfiguration);
        ConfigurationBuilder replicationConfigBuilder = new ConfigurationBuilder();
        if (clustered) {
            replicationConfigBuilder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
        }
        if (jdgEnabled = this.config.getBoolean("remoteStoreEnabled", Boolean.valueOf(false)).booleanValue()) {
            this.configureRemoteCacheStore(replicationConfigBuilder, async);
        }
        Configuration replicationEvictionCacheConfiguration = replicationConfigBuilder.build();
        this.cacheManager.defineConfiguration("work", replicationEvictionCacheConfiguration);
        ConfigurationBuilder counterConfigBuilder = new ConfigurationBuilder();
        counterConfigBuilder.invocationBatching().enable().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        counterConfigBuilder.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        counterConfigBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        long realmRevisionsMaxEntries = this.cacheManager.getCache("realms").getCacheConfiguration().eviction().maxEntries();
        realmRevisionsMaxEntries = realmRevisionsMaxEntries > 0L ? 2L * realmRevisionsMaxEntries : 20000L;
        this.cacheManager.defineConfiguration("realmRevisions", this.getRevisionCacheConfig(realmRevisionsMaxEntries));
        this.cacheManager.getCache("realmRevisions", true);
        long userRevisionsMaxEntries = this.cacheManager.getCache("users").getCacheConfiguration().eviction().maxEntries();
        userRevisionsMaxEntries = userRevisionsMaxEntries > 0L ? 2L * userRevisionsMaxEntries : 100000L;
        this.cacheManager.defineConfiguration("userRevisions", this.getRevisionCacheConfig(userRevisionsMaxEntries));
        this.cacheManager.getCache("userRevisions", true);
        this.cacheManager.defineConfiguration("keys", this.getKeysCacheConfig());
        this.cacheManager.getCache("keys", true);
    }

    private Configuration getRevisionCacheConfig(long maxEntries) {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.invocationBatching().enable().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        cb.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        cb.transaction().lockingMode(LockingMode.PESSIMISTIC);
        cb.eviction().strategy(EvictionStrategy.LRU).type(EvictionType.COUNT).size(maxEntries);
        return cb.build();
    }

    private void configureRemoteCacheStore(ConfigurationBuilder builder, boolean async) {
        String jdgServer = this.config.get("remoteStoreServer", "localhost");
        Integer jdgPort = this.config.getInt("remoteStorePort", Integer.valueOf(11222));
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)builder.persistence().passivation(false).addStore(RemoteStoreConfigurationBuilder.class)).fetchPersistentState(false)).ignoreModifications(false)).purgeOnStartup(false)).preload(false)).shared(true)).remoteCacheName("work").rawValues(true).forceReturnValues(false).marshaller(KeycloakHotRodMarshallerFactory.class.getName()).addServer().host(jdgServer).port(jdgPort.intValue()).async().enabled(async);
    }

    protected Configuration getKeysCacheConfig() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.eviction().strategy(EvictionStrategy.LRU).type(EvictionType.COUNT).size(1000L);
        cb.expiration().maxIdle(3600L, TimeUnit.SECONDS);
        return cb.build();
    }
}

