/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RoleModel;

public class OAuthGrantBean {
    private final String accessRequestMessage;
    private List<RoleModel> realmRolesRequested;
    private MultivaluedMap<String, ClientRoleEntry> resourceRolesRequested;
    private String code;
    private ClientModel client;
    private List<String> claimsRequested;

    public OAuthGrantBean(String code, ClientSessionModel clientSession, ClientModel client, List<RoleModel> realmRolesRequested, MultivaluedMap<String, RoleModel> resourceRolesRequested, List<ProtocolMapperModel> protocolMappersRequested, String accessRequestMessage) {
        this.code = code;
        this.client = client;
        this.realmRolesRequested = realmRolesRequested;
        if (resourceRolesRequested != null) {
            this.resourceRolesRequested = new MultivaluedMapImpl();
            for (List clientRoles : resourceRolesRequested.values()) {
                for (RoleModel role : clientRoles) {
                    ClientModel currentClient = (ClientModel)role.getContainer();
                    ClientRoleEntry roleEntry = new ClientRoleEntry(currentClient.getClientId(), currentClient.getName(), role.getName(), role.getDescription());
                    this.resourceRolesRequested.add((Object)currentClient.getClientId(), (Object)roleEntry);
                }
            }
        }
        this.accessRequestMessage = accessRequestMessage;
        LinkedList<String> claims = new LinkedList<String>();
        if (protocolMappersRequested != null) {
            for (ProtocolMapperModel model : protocolMappersRequested) {
                claims.add(model.getConsentText());
            }
        }
        if (claims.size() > 0) {
            this.claimsRequested = claims;
        }
    }

    public String getCode() {
        return this.code;
    }

    public MultivaluedMap<String, ClientRoleEntry> getResourceRolesRequested() {
        return this.resourceRolesRequested;
    }

    public List<RoleModel> getRealmRolesRequested() {
        return this.realmRolesRequested;
    }

    public String getClient() {
        return this.client.getClientId();
    }

    public List<String> getClaimsRequested() {
        return this.claimsRequested;
    }

    public String getAccessRequestMessage() {
        return this.accessRequestMessage;
    }

    public static class ClientRoleEntry {
        private final String clientId;
        private final String clientName;
        private final String roleName;
        private final String roleDescription;

        public ClientRoleEntry(String clientId, String clientName, String roleName, String roleDescription) {
            this.clientId = clientId;
            this.clientName = clientName;
            this.roleName = roleName;
            this.roleDescription = roleDescription;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientName() {
            return this.clientName;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public String getRoleDescription() {
            return this.roleDescription;
        }
    }
}

