/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.jose.jws.AlgorithmType;
import org.keycloak.keys.FailsafeHmacKeyProvider;
import org.keycloak.keys.FailsafeRsaKeyProvider;
import org.keycloak.keys.HmacKeyMetadata;
import org.keycloak.keys.HmacKeyProvider;
import org.keycloak.keys.KeyMetadata;
import org.keycloak.keys.KeyProvider;
import org.keycloak.keys.KeyProviderFactory;
import org.keycloak.keys.RsaKeyMetadata;
import org.keycloak.keys.RsaKeyProvider;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;

public class DefaultKeyManager
implements KeyManager {
    private static final Logger logger = Logger.getLogger(DefaultKeyManager.class);
    private final KeycloakSession session;
    private final Map<String, List<KeyProvider>> providersMap = new HashMap<String, List<KeyProvider>>();

    public DefaultKeyManager(KeycloakSession session) {
        this.session = session;
    }

    public KeyManager.ActiveRsaKey getActiveRsaKey(RealmModel realm) {
        for (KeyProvider p : this.getProviders(realm)) {
            RsaKeyProvider r;
            if (!p.getType().equals((Object)AlgorithmType.RSA) || (r = (RsaKeyProvider)p).getKid() == null || r.getPrivateKey() == null) continue;
            if (logger.isTraceEnabled()) {
                logger.tracev("Active key realm={0} kid={1}", (Object)realm.getName(), (Object)p.getKid());
            }
            String kid = p.getKid();
            return new KeyManager.ActiveRsaKey(kid, r.getPrivateKey(), r.getPublicKey(kid), r.getCertificate(kid));
        }
        throw new RuntimeException("Failed to get RSA keys");
    }

    public KeyManager.ActiveHmacKey getActiveHmacKey(RealmModel realm) {
        for (KeyProvider p : this.getProviders(realm)) {
            HmacKeyProvider h;
            if (!p.getType().equals((Object)AlgorithmType.HMAC) || (h = (HmacKeyProvider)p).getKid() == null || h.getSecretKey() == null) continue;
            if (logger.isTraceEnabled()) {
                logger.tracev("Active secret realm={0} kid={1}", (Object)realm.getName(), (Object)p.getKid());
            }
            String kid = p.getKid();
            return new KeyManager.ActiveHmacKey(kid, h.getSecretKey());
        }
        throw new RuntimeException("Failed to get keys");
    }

    public PublicKey getRsaPublicKey(RealmModel realm, String kid) {
        if (kid == null) {
            logger.warnv("KID is null, can't find public key", (Object)realm.getName(), (Object)kid);
            return null;
        }
        for (KeyProvider p : this.getProviders(realm)) {
            RsaKeyProvider r;
            PublicKey publicKey;
            if (!p.getType().equals((Object)AlgorithmType.RSA) || (publicKey = (r = (RsaKeyProvider)p).getPublicKey(kid)) == null) continue;
            if (logger.isTraceEnabled()) {
                logger.tracev("Found public key realm={0} kid={1}", (Object)realm.getName(), (Object)kid);
            }
            return publicKey;
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("Failed to find public key realm={0} kid={1}", (Object)realm.getName(), (Object)kid);
        }
        return null;
    }

    public Certificate getRsaCertificate(RealmModel realm, String kid) {
        if (kid == null) {
            logger.warnv("KID is null, can't find public key", (Object)realm.getName(), (Object)kid);
            return null;
        }
        for (KeyProvider p : this.getProviders(realm)) {
            RsaKeyProvider r;
            X509Certificate certificate;
            if (!p.getType().equals((Object)AlgorithmType.RSA) || (certificate = (r = (RsaKeyProvider)p).getCertificate(kid)) == null) continue;
            if (logger.isTraceEnabled()) {
                logger.tracev("Found certificate realm={0} kid={1}", (Object)realm.getName(), (Object)kid);
            }
            return certificate;
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("Failed to find certificate realm={0} kid={1}", (Object)realm.getName(), (Object)kid);
        }
        return null;
    }

    public SecretKey getHmacSecretKey(RealmModel realm, String kid) {
        if (kid == null) {
            logger.warnv("KID is null, can't find public key", (Object)realm.getName(), (Object)kid);
            return null;
        }
        for (KeyProvider p : this.getProviders(realm)) {
            HmacKeyProvider h;
            SecretKey s;
            if (!p.getType().equals((Object)AlgorithmType.HMAC) || (s = (h = (HmacKeyProvider)p).getSecretKey(kid)) == null) continue;
            if (logger.isTraceEnabled()) {
                logger.tracev("Found secret key realm={0} kid={1}", (Object)realm.getName(), (Object)kid);
            }
            return s;
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("Failed to find secret key realm={0} kid={1}", (Object)realm.getName(), (Object)kid);
        }
        return null;
    }

    public List<RsaKeyMetadata> getRsaKeys(RealmModel realm, boolean includeDisabled) {
        LinkedList<RsaKeyMetadata> keys = new LinkedList<RsaKeyMetadata>();
        for (KeyProvider p : this.getProviders(realm)) {
            if (!(p instanceof RsaKeyProvider)) continue;
            if (includeDisabled) {
                keys.addAll(p.getKeyMetadata());
                continue;
            }
            List metadata = p.getKeyMetadata();
            metadata.stream().filter(k -> k.getStatus() != KeyMetadata.Status.DISABLED).forEach(k -> keys.add((RsaKeyMetadata)k));
        }
        return keys;
    }

    public List<HmacKeyMetadata> getHmacKeys(RealmModel realm, boolean includeDisabled) {
        LinkedList<HmacKeyMetadata> keys = new LinkedList<HmacKeyMetadata>();
        for (KeyProvider p : this.getProviders(realm)) {
            if (!(p instanceof HmacKeyProvider)) continue;
            if (includeDisabled) {
                keys.addAll(p.getKeyMetadata());
                continue;
            }
            List metadata = p.getKeyMetadata();
            metadata.stream().filter(k -> k.getStatus() != KeyMetadata.Status.DISABLED).forEach(k -> keys.add((HmacKeyMetadata)k));
        }
        return keys;
    }

    private List<KeyProvider> getProviders(RealmModel realm) {
        List<KeyProvider> providers = this.providersMap.get(realm.getId());
        if (providers == null) {
            providers = new LinkedList<KeyProvider>();
            LinkedList<ComponentModel> components = new LinkedList<ComponentModel>(realm.getComponents(realm.getId(), KeyProvider.class.getName()));
            components.sort(new ProviderComparator());
            boolean activeRsa = false;
            boolean activeHmac = false;
            for (ComponentModel c : components) {
                try {
                    RsaKeyProvider r;
                    ProviderFactory f = this.session.getKeycloakSessionFactory().getProviderFactory(KeyProvider.class, c.getProviderId());
                    KeyProviderFactory factory = (KeyProviderFactory)f;
                    KeyProvider provider = factory.create(this.session, c);
                    this.session.enlistForClose((Provider)provider);
                    providers.add(provider);
                    if (provider.getType().equals((Object)AlgorithmType.RSA)) {
                        r = (RsaKeyProvider)provider;
                        if (r.getKid() == null || r.getPrivateKey() == null) continue;
                        activeRsa = true;
                        continue;
                    }
                    if (!provider.getType().equals((Object)AlgorithmType.HMAC) || (r = (HmacKeyProvider)provider).getKid() == null || r.getSecretKey() == null) continue;
                    activeHmac = true;
                }
                catch (Throwable t) {
                    logger.errorv(t, "Failed to load provider {0}", (Object)c.getId());
                }
            }
            if (!activeRsa) {
                providers.add((KeyProvider)new FailsafeRsaKeyProvider());
            }
            if (!activeHmac) {
                providers.add((KeyProvider)new FailsafeHmacKeyProvider());
            }
            this.providersMap.put(realm.getId(), providers);
        }
        return providers;
    }

    private class ProviderComparator
    implements Comparator<ComponentModel> {
        private ProviderComparator() {
        }

        @Override
        public int compare(ComponentModel o1, ComponentModel o2) {
            int i = Long.compare(o2.get("priority", 0L), o1.get("priority", 0L));
            return i != 0 ? i : o1.getId().compareTo(o2.getId());
        }
    }
}

