/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.loader;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.utils.JWKSHttpUtils;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.services.util.CertificateInfoHelper;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.util.JWKSUtils;

public class ClientPublicKeyLoader
implements PublicKeyLoader {
    private static final Logger logger = Logger.getLogger(ClientPublicKeyLoader.class);
    private final KeycloakSession session;
    private final ClientModel client;

    public ClientPublicKeyLoader(KeycloakSession session, ClientModel client) {
        this.session = session;
        this.client = client;
    }

    public Map<String, PublicKey> loadKeys() throws Exception {
        OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientModel(this.client);
        if (config.isUseJwksUrl()) {
            String jwksUrl = config.getJwksUrl();
            jwksUrl = ResolveRelative.resolveRelativeUri(this.session.getContext().getUri().getRequestUri(), this.client.getRootUrl(), jwksUrl);
            JSONWebKeySet jwks = JWKSHttpUtils.sendJwksRequest(this.session, jwksUrl);
            return JWKSUtils.getKeysForUse((JSONWebKeySet)jwks, (JWK.Use)JWK.Use.SIG);
        }
        try {
            CertificateRepresentation certInfo = CertificateInfoHelper.getCertificateFromClient(this.client, "jwt.credential");
            PublicKey publicKey = ClientPublicKeyLoader.getSignatureValidationKey(certInfo);
            String kid = certInfo.getKid() != null ? certInfo.getKid() : KeyUtils.createKeyId((Key)publicKey);
            return Collections.singletonMap(kid, publicKey);
        }
        catch (ModelException me) {
            logger.warnf((Throwable)me, "Unable to retrieve publicKey for verify signature of client '%s' . Error details: %s", (Object)this.client.getClientId(), (Object)me.getMessage());
            return Collections.emptyMap();
        }
    }

    private static PublicKey getSignatureValidationKey(CertificateRepresentation certInfo) throws ModelException {
        String encodedCertificate = certInfo.getCertificate();
        String encodedPublicKey = certInfo.getPublicKey();
        if (encodedCertificate == null && encodedPublicKey == null) {
            throw new ModelException("Client doesn't have certificate or publicKey configured");
        }
        if (encodedCertificate != null && encodedPublicKey != null) {
            throw new ModelException("Client has both publicKey and certificate configured");
        }
        if (encodedCertificate != null) {
            X509Certificate clientCert = KeycloakModelUtils.getCertificate((String)encodedCertificate);
            return clientCert.getPublicKey();
        }
        return KeycloakModelUtils.getPublicKey((String)encodedPublicKey);
    }
}

