/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.oidc;

import java.util.HashSet;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.SubjectType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.clientregistration.AbstractClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.validation.PairwiseClientValidator;
import org.keycloak.services.validation.ValidationMessages;

public class OIDCClientRegistrationContext
extends AbstractClientRegistrationContext {
    private final OIDCClientRepresentation oidcRep;

    public OIDCClientRegistrationContext(KeycloakSession session, ClientRepresentation client, ClientRegistrationProvider provider, OIDCClientRepresentation oidcRep) {
        super(session, client, provider);
        this.oidcRep = oidcRep;
    }

    @Override
    public boolean validateClient(ValidationMessages validationMessages) {
        boolean valid = super.validateClient(validationMessages);
        String rootUrl = this.client.getRootUrl();
        HashSet<String> redirectUris = new HashSet<String>();
        if (this.client.getRedirectUris() != null) {
            redirectUris.addAll(this.client.getRedirectUris());
        }
        SubjectType subjectType = SubjectType.parse(this.oidcRep.getSubjectType());
        String sectorIdentifierUri = this.oidcRep.getSectorIdentifierUri();
        if (SubjectType.PAIRWISE == subjectType || sectorIdentifierUri != null && !sectorIdentifierUri.isEmpty()) {
            valid = valid && PairwiseClientValidator.validate(this.session, rootUrl, redirectUris, this.oidcRep.getSectorIdentifierUri(), validationMessages);
        }
        return valid;
    }
}

