/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.space.AbstractSisuIndex;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.QualifiedTypeListener;
import org.eclipse.sisu.space.QualifiedTypeVisitor;
import org.eclipse.sisu.space.SpaceScanner;
import org.eclipse.sisu.space.URLClassSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SisuIndex
extends AbstractSisuIndex
implements QualifiedTypeListener {
    private final File targetDirectory;

    public SisuIndex(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public static void main(String[] args) {
        ArrayList<URL> indexPath = new ArrayList<URL>(args.length);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                indexPath.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                Logs.warn("Bad classpath element: {}", path, e);
            }
            ++n2;
        }
        ClassLoader parent = SisuIndex.class.getClassLoader();
        URL[] urls = indexPath.toArray(new URL[indexPath.size()]);
        ClassLoader loader = urls.length > 0 ? URLClassLoader.newInstance(urls, parent) : parent;
        new SisuIndex(new File(".")).index(new URLClassSpace(loader));
    }

    public void index(ClassSpace space) {
        try {
            new SpaceScanner(space).accept(new QualifiedTypeVisitor(this));
        }
        finally {
            this.flushIndex();
        }
    }

    @Override
    public void hear(Class<?> qualifiedType, Object source) {
        this.addClassToIndex("javax.inject.Named", qualifiedType.getName());
    }

    @Override
    protected void info(String message) {
        System.out.println("[INFO] " + message);
    }

    @Override
    protected void warn(String message) {
        System.out.println("[WARN] " + message);
    }

    @Override
    protected Reader getReader(String path) throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(new File(this.targetDirectory, path)), "UTF-8");
    }

    @Override
    protected Writer getWriter(String path) throws IOException {
        File index = new File(this.targetDirectory, path);
        File parent = index.getParentFile();
        if (parent.isDirectory() || parent.mkdirs()) {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(index), "UTF-8");
        }
        throw new IOException("Error creating: " + parent);
    }
}

