/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd.api;

import cx.ath.matthew.LibraryLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.sssd.infopipe.InfoPipe;
import org.jboss.logging.Logger;
import org.keycloak.federation.sssd.api.SSSDException;
import org.keycloak.models.UserModel;

public class Sssd {
    private static DBusConnection dBusConnection;
    private String username;
    private static final Logger logger;

    public static void disconnect() {
        dBusConnection.disconnect();
    }

    private Sssd() {
    }

    public Sssd(String username) {
        this.username = username;
        try {
            if (LibraryLoader.load().succeed()) {
                dBusConnection = DBusConnection.getConnection(0);
            }
        }
        catch (DBusException e) {
            e.printStackTrace();
        }
    }

    public static String getRawAttribute(Variant variant) {
        Vector value;
        if (variant != null && (value = (Vector)variant.getValue()).size() >= 1) {
            return value.get(0).toString();
        }
        return null;
    }

    public List<String> getGroups() {
        List<String> userGroups;
        try {
            InfoPipe infoPipe = dBusConnection.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe", InfoPipe.class);
            userGroups = infoPipe.getUserGroups(this.username);
        }
        catch (Exception e) {
            throw new SSSDException("Failed to retrieve user's groups from SSSD. Check if SSSD service is active.");
        }
        return userGroups;
    }

    public static boolean isAvailable() {
        boolean sssdAvailable = false;
        try {
            if (LibraryLoader.load().succeed()) {
                DBusConnection connection = DBusConnection.getConnection(0);
                InfoPipe infoPipe = connection.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe", InfoPipe.class);
                if (infoPipe.ping("PING") == null || infoPipe.ping("PING").isEmpty()) {
                    logger.debugv("SSSD is not available in your system. Federation provider will be disabled.", new Object[0]);
                } else {
                    sssdAvailable = true;
                }
            } else {
                logger.debugv("The RPM libunix-dbus-java is not installed. SSSD Federation provider will be disabled.", new Object[0]);
            }
        }
        catch (Exception e) {
            logger.debugv("SSSD is not available in your system. Federation provider will be disabled.", (Object)e);
        }
        return sssdAvailable;
    }

    public User getUser() {
        String[] attr = new String[]{"mail", "givenname", "sn", "telephoneNumber"};
        User user = null;
        try {
            InfoPipe infoPipe = dBusConnection.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe", InfoPipe.class);
            user = new User(infoPipe.getUserAttributes(this.username, Arrays.asList(attr)));
        }
        catch (Exception e) {
            throw new SSSDException("Failed to retrieve user's attributes. Check if SSSD service is active.");
        }
        return user;
    }

    static {
        logger = Logger.getLogger(Sssd.class);
    }

    public class User {
        private final String email;
        private final String firstName;
        private final String lastName;

        public User(Map<String, Variant> userAttributes) {
            this.email = Sssd.getRawAttribute(userAttributes.get("mail"));
            this.firstName = Sssd.getRawAttribute(userAttributes.get("givenname"));
            this.lastName = Sssd.getRawAttribute(userAttributes.get("sn"));
        }

        public String getEmail() {
            return this.email;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            UserModel userModel = (UserModel)o;
            if (this.firstName != null && !this.firstName.equals(userModel.getFirstName())) {
                return false;
            }
            if (this.lastName != null && !this.lastName.equals(userModel.getLastName())) {
                return false;
            }
            if (this.email != null) {
                return this.email.equals(userModel.getEmail());
            }
            return this.email == userModel.getEmail();
        }

        public int hashCode() {
            int result = this.email != null ? this.email.hashCode() : 0;
            result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
            result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
            return result;
        }
    }
}

