/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.facttemplates;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.facttemplates.Fact;
import org.drools.core.facttemplates.FactImpl;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.facttemplates.FieldTemplate;

public class FactTemplateImpl
implements FactTemplate {
    private FieldTemplate[] fields;
    private InternalKnowledgePackage pkg;
    private String name;

    private static int hashCode(Object[] array) {
        int PRIME = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
        }
        return result;
    }

    public FactTemplateImpl() {
    }

    public FactTemplateImpl(InternalKnowledgePackage pkg, String name, FieldTemplate[] fields) {
        this.pkg = pkg;
        this.name = name;
        this.fields = fields;
        this.pkg.addFactTemplate(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.pkg = (InternalKnowledgePackage)in.readObject();
        this.name = (String)in.readObject();
        this.fields = (FieldTemplate[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.pkg);
        out.writeObject(this.name);
        out.writeObject(this.fields);
    }

    @Override
    public InternalKnowledgePackage getPackage() {
        return this.pkg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumberOfFields() {
        return this.fields.length;
    }

    @Override
    public FieldTemplate[] getAllFieldTemplates() {
        return this.fields;
    }

    @Override
    public FieldTemplate getFieldTemplate(String name) {
        for (int idx = 0; idx < this.fields.length; ++idx) {
            if (!this.fields[idx].getName().equals(name)) continue;
            return this.fields[idx];
        }
        return null;
    }

    @Override
    public FieldTemplate getFieldTemplate(int index) {
        return this.fields[index];
    }

    @Override
    public int getFieldTemplateIndex(String name) {
        for (int index = 0; index < this.fields.length; ++index) {
            if (!this.fields[index].getName().equals(name)) continue;
            return index;
        }
        return -1;
    }

    @Override
    public Fact createFact(long id) {
        return new FactImpl(this, id);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(" + this.name + " ");
        buf.append(")");
        return buf.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + FactTemplateImpl.hashCode(this.fields);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.pkg.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FactTemplateImpl other = (FactTemplateImpl)object;
        if (!Arrays.equals(this.fields, other.fields)) {
            return false;
        }
        return this.pkg.equals(other.pkg) && this.name.equals(other.name);
    }
}

