/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.authorization.infinispan.InfinispanStoreFactoryProvider;
import org.keycloak.models.authorization.infinispan.entities.CachedResource;
import org.keycloak.models.cache.authorization.CachedStoreFactoryProvider;

public class CachedResourceStore
implements ResourceStore {
    private static final String RESOURCE_ID_CACHE_PREFIX = "rsc-id-";
    private static final String RESOURCE_NAME_CACHE_PREFIX = "rsc-name-";
    private final CachedStoreFactoryProvider cacheStoreFactory;
    private final InfinispanStoreFactoryProvider.CacheTransaction transaction;
    private final List<String> cacheKeys;
    private StoreFactory delegateStoreFactory;
    private ResourceStore delegate;
    private final Cache<String, Map<String, List<CachedResource>>> cache;

    public CachedResourceStore(KeycloakSession session, CachedStoreFactoryProvider cacheStoreFactory, InfinispanStoreFactoryProvider.CacheTransaction transaction, StoreFactory delegate) {
        this.cacheStoreFactory = cacheStoreFactory;
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        this.cache = provider.getCache("authorization");
        this.transaction = transaction;
        this.cacheKeys = new ArrayList<String>();
        this.cacheKeys.add("findByOwner");
        this.cacheKeys.add("findByUri");
        this.cacheKeys.add("findByName");
        this.delegateStoreFactory = delegate;
    }

    public Resource create(String name, ResourceServer resourceServer, String owner) {
        Resource resource = this.getDelegate().create(name, this.getDelegateStoreFactory().getResourceServerStore().findById(resourceServer.getId()), owner);
        this.transaction.whenRollback(() -> this.resolveResourceServerCache(resourceServer.getId()).remove(this.getCacheKeyForResource(resource.getId())));
        this.transaction.whenCommit(() -> this.invalidateCache(resourceServer.getId()));
        return this.createAdapter(new CachedResource(resource));
    }

    public void delete(String id) {
        Resource resource = this.getDelegate().findById(id, null);
        if (resource == null) {
            return;
        }
        ResourceServer resourceServer = resource.getResourceServer();
        this.getDelegate().delete(id);
        this.transaction.whenCommit(() -> this.invalidateCache(resourceServer.getId()));
    }

    public Resource findById(String id, String resourceServerId) {
        String cacheKeyForResource = this.getCacheKeyForResource(id);
        List<CachedResource> cached = this.resolveResourceServerCache(resourceServerId).get(cacheKeyForResource);
        if (cached == null) {
            Resource resource = this.getDelegate().findById(id, resourceServerId);
            if (resource != null) {
                CachedResource cachedResource = new CachedResource(resource);
                this.resolveResourceServerCache(resourceServerId).put(cacheKeyForResource, Arrays.asList(cachedResource));
                return this.createAdapter(cachedResource);
            }
            return null;
        }
        return this.createAdapter(cached.get(0));
    }

    public List<Resource> findByOwner(String ownerId, String resourceServerId) {
        return this.cacheResult(resourceServerId, "findByOwner" + ownerId, () -> this.getDelegate().findByOwner(ownerId, resourceServerId));
    }

    public List<Resource> findByUri(String uri, String resourceServerId) {
        return this.cacheResult(resourceServerId, "findByUri" + uri, () -> this.getDelegate().findByUri(uri, resourceServerId));
    }

    public List<Resource> findByResourceServer(String resourceServerId) {
        return this.getDelegate().findByResourceServer(resourceServerId);
    }

    public List<Resource> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        return this.getDelegate().findByResourceServer(attributes, resourceServerId, firstResult, maxResult);
    }

    public List<Resource> findByScope(List<String> id, String resourceServerId) {
        return this.getDelegate().findByScope(id, resourceServerId);
    }

    public Resource findByName(String name, String resourceServerId) {
        String cacheKeyForResource = this.getCacheKeyForResourceName(name, resourceServerId);
        List<CachedResource> cached = this.resolveResourceServerCache(resourceServerId).get(cacheKeyForResource);
        if (cached == null) {
            Resource resource = this.getDelegate().findByName(name, resourceServerId);
            if (resource != null) {
                this.invalidateCache(resourceServerId);
                this.resolveResourceServerCache(resourceServerId).put(cacheKeyForResource, Arrays.asList(new CachedResource(resource)));
                return this.findById(resource.getId(), resourceServerId);
            }
            return null;
        }
        return this.createAdapter(cached.get(0));
    }

    public List<Resource> findByType(String type, String resourceServerId) {
        return this.getDelegate().findByType(type, resourceServerId);
    }

    private String getCacheKeyForResource(String id) {
        return RESOURCE_ID_CACHE_PREFIX + id;
    }

    private String getCacheKeyForResourceName(String name, String resourceServerId) {
        return RESOURCE_NAME_CACHE_PREFIX + name + "-" + resourceServerId;
    }

    private ResourceStore getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.getDelegateStoreFactory().getResourceStore();
        }
        return this.delegate;
    }

    private StoreFactory getDelegateStoreFactory() {
        return this.delegateStoreFactory;
    }

    private Resource createAdapter(final CachedResource cached) {
        return new Resource(){
            private List<Scope> scopes;
            private Resource updated;

            public String getId() {
                return cached.getId();
            }

            public String getName() {
                return cached.getName();
            }

            public void setName(String name) {
                this.getDelegateForUpdate().setName(name);
                cached.setName(name);
            }

            public String getUri() {
                return cached.getUri();
            }

            public void setUri(String uri) {
                this.getDelegateForUpdate().setUri(uri);
                cached.setUri(uri);
            }

            public String getType() {
                return cached.getType();
            }

            public void setType(String type) {
                this.getDelegateForUpdate().setType(type);
                cached.setType(type);
            }

            public List<Scope> getScopes() {
                if (this.scopes == null) {
                    this.scopes = new ArrayList<Scope>();
                    for (String id : cached.getScopesIds()) {
                        Scope scope = CachedResourceStore.this.getCachedStoreFactory().getScopeStore().findById(id, cached.getResourceServerId());
                        if (scope == null) continue;
                        this.scopes.add(scope);
                    }
                }
                return this.scopes;
            }

            public String getIconUri() {
                return cached.getIconUri();
            }

            public void setIconUri(String iconUri) {
                this.getDelegateForUpdate().setIconUri(iconUri);
                cached.setIconUri(iconUri);
            }

            public ResourceServer getResourceServer() {
                return CachedResourceStore.this.getCachedStoreFactory().getResourceServerStore().findById(cached.getResourceServerId());
            }

            public String getOwner() {
                return cached.getOwner();
            }

            public void updateScopes(Set<Scope> scopes) {
                this.getDelegateForUpdate().updateScopes(scopes.stream().map(scope -> CachedResourceStore.this.getDelegateStoreFactory().getScopeStore().findById(scope.getId(), cached.getResourceServerId())).collect(Collectors.toSet()));
                cached.updateScopes(scopes);
            }

            private Resource getDelegateForUpdate() {
                if (this.updated == null) {
                    String resourceServerId = cached.getResourceServerId();
                    this.updated = CachedResourceStore.this.getDelegate().findById(this.getId(), resourceServerId);
                    if (this.updated == null) {
                        throw new IllegalStateException("Not found in database");
                    }
                    CachedResourceStore.this.transaction.whenCommit(() -> CachedResourceStore.this.invalidateCache(resourceServerId));
                    CachedResourceStore.this.transaction.whenRollback(() -> CachedResourceStore.this.resolveResourceServerCache(resourceServerId).remove(CachedResourceStore.this.getCacheKeyForResource(cached.getId())));
                }
                return this.updated;
            }
        };
    }

    private CachedStoreFactoryProvider getCachedStoreFactory() {
        return this.cacheStoreFactory;
    }

    private List<Resource> cacheResult(String resourceServerId, String key, Supplier<List<Resource>> provider) {
        List cached = this.resolveResourceServerCache(resourceServerId).computeIfAbsent(key, o -> {
            List result = (List)provider.get();
            if (result.isEmpty()) {
                return null;
            }
            return result.stream().map(resource -> new CachedResource((Resource)resource)).collect(Collectors.toList());
        });
        if (cached == null) {
            return Collections.emptyList();
        }
        ArrayList<Resource> adapters = new ArrayList<Resource>();
        for (CachedResource resource : cached) {
            adapters.add(this.createAdapter(resource));
        }
        return adapters;
    }

    private void invalidateCache(String resourceServerId) {
        this.cache.remove((Object)resourceServerId);
    }

    private Map<String, List<CachedResource>> resolveResourceServerCache(String id) {
        return (Map)this.cache.computeIfAbsent((Object)id, key -> new HashMap());
    }
}

