/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class UserSessionAdapter
implements UserSessionModel {
    private final KeycloakSession session;
    private final InfinispanUserSessionProvider provider;
    private final Cache<String, SessionEntity> cache;
    private final RealmModel realm;
    private final UserSessionEntity entity;
    private final boolean offline;

    public UserSessionAdapter(KeycloakSession session, InfinispanUserSessionProvider provider, Cache<String, SessionEntity> cache, RealmModel realm, UserSessionEntity entity, boolean offline) {
        this.session = session;
        this.provider = provider;
        this.cache = cache;
        this.realm = realm;
        this.entity = entity;
        this.offline = offline;
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getBrokerSessionId() {
        return this.entity.getBrokerSessionId();
    }

    public String getBrokerUserId() {
        return this.entity.getBrokerUserId();
    }

    public UserModel getUser() {
        return this.session.users().getUserById(this.entity.getUser(), this.realm);
    }

    public String getLoginUsername() {
        return this.entity.getLoginUsername();
    }

    public String getIpAddress() {
        return this.entity.getIpAddress();
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public boolean isRememberMe() {
        return this.entity.isRememberMe();
    }

    public int getStarted() {
        return this.entity.getStarted();
    }

    public int getLastSessionRefresh() {
        return this.entity.getLastSessionRefresh();
    }

    public void setLastSessionRefresh(int lastSessionRefresh) {
        this.entity.setLastSessionRefresh(lastSessionRefresh);
        this.update();
    }

    public String getNote(String name) {
        return this.entity.getNotes() != null ? this.entity.getNotes().get(name) : null;
    }

    public void setNote(String name, String value) {
        if (this.entity.getNotes() == null) {
            this.entity.setNotes(new HashMap<String, String>());
        }
        this.entity.getNotes().put(name, value);
        this.update();
    }

    public void removeNote(String name) {
        if (this.entity.getNotes() != null) {
            this.entity.getNotes().remove(name);
            this.update();
        }
    }

    public Map<String, String> getNotes() {
        return this.entity.getNotes();
    }

    public UserSessionModel.State getState() {
        return this.entity.getState();
    }

    public void setState(UserSessionModel.State state) {
        this.entity.setState(state);
        this.update();
    }

    public List<ClientSessionModel> getClientSessions() {
        if (this.entity.getClientSessions() != null) {
            LinkedList<ClientSessionModel> clientSessions = new LinkedList<ClientSessionModel>();
            for (String c : this.entity.getClientSessions()) {
                ClientSessionModel clientSession = this.provider.getClientSession(this.realm, c, this.offline);
                if (clientSession == null) continue;
                clientSessions.add(clientSession);
            }
            return clientSessions;
        }
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    UserSessionEntity getEntity() {
        return this.entity;
    }

    void update() {
        this.provider.getTx().replace(this.cache, this.entity.getId(), this.entity);
    }
}

