/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.dblock;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RealmProviderFactory;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.dblock.DBLockProviderFactory;

public class DBLockManager {
    protected static final Logger logger = Logger.getLogger(DBLockManager.class);
    private final KeycloakSession session;

    public DBLockManager(KeycloakSession session) {
        this.session = session;
    }

    public void checkForcedUnlock() {
        if (Boolean.getBoolean("keycloak.dblock.forceUnlock")) {
            DBLockProvider lock = this.getDBLock();
            if (lock.supportsForcedUnlock()) {
                logger.warn((Object)"Forced release of DB lock at startup requested by System property. Make sure to not use this in production environment! And especially when more cluster nodes are started concurrently.");
                lock.releaseLock();
            } else {
                throw new IllegalStateException("Forced unlock requested, but provider " + lock + " doesn't support it");
            }
        }
    }

    public DBLockProvider getDBLock() {
        String realmProviderId = this.getRealmProviderId();
        return (DBLockProvider)this.session.getProvider(DBLockProvider.class, realmProviderId);
    }

    public DBLockProviderFactory getDBLockFactory() {
        String realmProviderId = this.getRealmProviderId();
        return (DBLockProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(DBLockProvider.class, realmProviderId);
    }

    private String getRealmProviderId() {
        RealmProviderFactory realmProviderFactory = (RealmProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(RealmProvider.class);
        return realmProviderFactory.getId();
    }
}

