/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.session;

import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ProviderFactory;

public interface UserSessionPersisterProviderFactory
extends ProviderFactory<UserSessionPersisterProvider> {
    default public void postInit(KeycloakSessionFactory factory) {
        factory.register(new ProviderEventListener(){

            public void onEvent(ProviderEvent event) {
                if (event instanceof UserModel.UserRemovedEvent) {
                    UserModel.UserRemovedEvent userRemovedEvent = (UserModel.UserRemovedEvent)event;
                    UserSessionPersisterProvider provider = (UserSessionPersisterProvider)userRemovedEvent.getKeycloakSession().getProvider(UserSessionPersisterProvider.class, UserSessionPersisterProviderFactory.this.getId());
                    provider.onUserRemoved(userRemovedEvent.getRealm(), userRemovedEvent.getUser());
                }
            }
        });
    }
}

