/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.policy.PasswordPolicyManagerProvider;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class DefaultPasswordPolicyManagerProvider
implements PasswordPolicyManagerProvider {
    private KeycloakSession session;

    public DefaultPasswordPolicyManagerProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public PolicyError validate(RealmModel realm, UserModel user, String password) {
        for (PasswordPolicyProvider p : this.getProviders(realm, this.session)) {
            PolicyError policyError = p.validate(realm, user, password);
            if (policyError == null) continue;
            return policyError;
        }
        return null;
    }

    @Override
    public PolicyError validate(String user, String password) {
        for (PasswordPolicyProvider p : this.getProviders(this.session)) {
            PolicyError policyError = p.validate(user, password);
            if (policyError == null) continue;
            return policyError;
        }
        return null;
    }

    public void close() {
    }

    private List<PasswordPolicyProvider> getProviders(KeycloakSession session) {
        return this.getProviders(session.getContext().getRealm(), session);
    }

    private List<PasswordPolicyProvider> getProviders(RealmModel realm, KeycloakSession session) {
        LinkedList<PasswordPolicyProvider> list = new LinkedList<PasswordPolicyProvider>();
        PasswordPolicy policy = realm.getPasswordPolicy();
        for (String id : policy.getPolicies()) {
            PasswordPolicyProvider provider = (PasswordPolicyProvider)session.getProvider(PasswordPolicyProvider.class, id);
            list.add(provider);
        }
        return list;
    }
}

