/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import org.keycloak.models.KeycloakContext;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class UpperCasePasswordPolicyProvider
implements PasswordPolicyProvider {
    private static final String ERROR_MESSAGE = "invalidPasswordMinUpperCaseCharsMessage";
    private KeycloakContext context;

    public UpperCasePasswordPolicyProvider(KeycloakContext context) {
        this.context = context;
    }

    public PolicyError validate(String username, String password) {
        int min = (Integer)this.context.getRealm().getPasswordPolicy().getPolicyConfig("upperCase");
        int count = 0;
        for (char c : password.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            ++count;
        }
        return count < min ? new PolicyError(ERROR_MESSAGE, new Object[]{min}) : null;
    }

    public PolicyError validate(RealmModel realm, UserModel user, String password) {
        return this.validate(user.getUsername(), password);
    }

    public Object parseConfig(String value) {
        return value != null ? Integer.parseInt(value) : 1;
    }

    public void close() {
    }
}

